/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.MutableCorrelationContext;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactory;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactoryRegistry;

public final class ThreadLocalCorrelationContext
implements MutableCorrelationContext {
    private final ThreadLocal<String> correlationId = new ThreadLocal();
    private final WrapperFactoryRegistry wrapperFactories;

    public ThreadLocalCorrelationContext(WrapperFactoryRegistry wrapperFactories) {
        this.wrapperFactories = wrapperFactories;
    }

    public String getCorrelationId() {
        String corrid = this.correlationId.get();
        if (null == corrid) {
            this.correlationId.remove();
        }
        return corrid;
    }

    @Override
    public void setCorrelationId(String corrid) {
        if (null == corrid) {
            throw new IllegalArgumentException("The correlation ID cannot be null.");
        }
        this.correlationId.set(corrid);
    }

    @Override
    public void clearCorrelationId() {
        this.correlationId.remove();
    }

    public <T> T wrapExecutable(Class<T> type, T instance) {
        if (null == type | null == instance) {
            throw new IllegalArgumentException("The type or instance parameter cannot be null.");
        }
        WrapperFactory<T> wrapperFactory = this.wrapperFactories.getWrapperFactory(type);
        return wrapperFactory.wrap(this, instance);
    }
}

