/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WrapperFactoryRegistry {
    private static final Logger logger = Logger.getLogger(WrapperFactoryRegistry.class.getName());
    private final Map<Class<?>, WrapperFactory<?>> wrapperFactories = new HashMap();

    public <T> void registerWrapperFactory(Class<T> forType, WrapperFactory<T> instance) {
        if (null == forType | null == instance) {
            throw new IllegalArgumentException("The wrapper type or instance cannot be null");
        }
        WrapperFactory<T> oldFactory = this.wrapperFactories.put(forType, instance);
        if (null != oldFactory && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Replaced wrapper factory for type " + forType + "; Original=" + oldFactory.getClass().getName() + "; Replacement=" + instance.getClass().getName());
        }
    }

    public <T> WrapperFactory<T> getWrapperFactory(Class<T> type) {
        if (null == type) {
            throw new IllegalArgumentException("The type cannot be null");
        }
        WrapperFactory<?> wrapperFactory = this.wrapperFactories.get(type);
        if (null == wrapperFactory) {
            throw new IllegalArgumentException("Unsupported wrapper type: " + type);
        }
        return wrapperFactory;
    }
}

