/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl.idgen;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.idgen.CorrelationIdGenerator;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.util.Pool;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.connector.Request;

public final class SequentialIdGenerator
implements CorrelationIdGenerator {
    private static final int POOL_CAPACITY_HINT = 32;
    private static final int EXPECTED_CORRELATION_ID_LENGTH = 16;
    private static final int MIN_BYTE_POSITION_IN_LONG = 0;
    private static final int MAX_BYTE_POSITION_IN_LONG = 7;
    private static final int EIGHT_BITS = 8;
    private static final int MASK_BYTE_HIGH = 240;
    private static final int MASK_BYTE_LOW = 15;
    private static final int MASK_BYTE_FULL = 255;
    private final char[] hexAlphabet;
    private final Pool<StringBuilder> stringBuilderPool;
    private final AtomicLong idSequence;

    public SequentialIdGenerator() {
        this(new Random().nextLong());
    }

    public SequentialIdGenerator(long initialValue) {
        this.idSequence = new AtomicLong(initialValue);
        this.stringBuilderPool = SequentialIdGenerator.initStringBuilderPool(16);
        this.hexAlphabet = SequentialIdGenerator.initHexAlphabet();
    }

    private static char[] initHexAlphabet() {
        int i;
        char[] hex = new char[16];
        for (i = 0; i < 10; ++i) {
            hex[i] = (char)(48 + i);
        }
        for (i = 0; i < 6; ++i) {
            hex[i + 10] = (char)(65 + i);
        }
        return hex;
    }

    private static Pool<StringBuilder> initStringBuilderPool(final int capacity) {
        return new Pool<StringBuilder>(new Pool.Factory<StringBuilder>(){

            @Override
            public StringBuilder createInstance() {
                return new StringBuilder(capacity);
            }
        }, new Pool.Recycler<StringBuilder>(){

            @Override
            public StringBuilder recycle(StringBuilder instance) {
                instance.setLength(0);
                return instance;
            }
        }, 32);
    }

    @Override
    public String createCorrelationIdFor(Request request) {
        StringBuilder stringBuilder = this.stringBuilderPool.take();
        long nextId = this.idSequence.incrementAndGet();
        this.appendAsHex(stringBuilder, nextId);
        String correlationId = stringBuilder.toString();
        this.stringBuilderPool.returnToPool(stringBuilder);
        return correlationId;
    }

    private void appendAsHex(StringBuilder stringBuilder, long value) {
        for (int bytePosition = 7; bytePosition >= 0; --bytePosition) {
            byte theByte = (byte)(value >>> bytePosition * 8 & 0xFFL);
            stringBuilder.append(this.hexAlphabet[(theByte & 0xF0) >>> 4]);
            stringBuilder.append(this.hexAlphabet[theByte & 0xF]);
        }
    }
}

