/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl.util;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class Pool<T> {
    private static final int MIN_BUCKETS = 4;
    private final AtomicInteger bucketSelector;
    private final Factory<T> objectFactory;
    private final Recycler<T> objectRecycler;
    private final BlockingQueue<T>[] buckets;

    public Pool(Factory<T> objectFactory, Recycler<T> objectRecycler, int capacityHint) {
        if (capacityHint <= 0) {
            throw new IllegalArgumentException("The capacity hint cannot be less than 1. Current value: " + capacityHint);
        }
        this.objectFactory = Objects.requireNonNull(objectFactory);
        this.objectRecycler = Objects.requireNonNull(objectRecycler);
        this.bucketSelector = new AtomicInteger();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.buckets = new BlockingQueue[Math.max(4, availableProcessors * 2)];
        int capacityPerBucket = 1 + capacityHint / this.buckets.length;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new ArrayBlockingQueue<T>(capacityPerBucket);
        }
    }

    public T take() {
        int bucket = this.selectBucketOnRetrieval();
        Object instance = this.buckets[bucket].poll();
        if (null == instance) {
            instance = this.objectFactory.createInstance();
        }
        return (T)instance;
    }

    private int selectBucketOnRetrieval() {
        return Math.abs(this.bucketSelector.getAndIncrement()) % this.buckets.length;
    }

    public void returnToPool(T instance) {
        T obj = this.objectRecycler.recycle(instance);
        if (null != obj) {
            int bucket = this.selectBucketOnReturn();
            this.buckets[bucket].offer(instance);
        }
    }

    private int selectBucketOnReturn() {
        return Math.abs(this.bucketSelector.decrementAndGet()) % this.buckets.length;
    }

    public static interface Recycler<T> {
        public T recycle(T var1);
    }

    public static interface Factory<T> {
        public T createInstance();
    }
}

