/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl.wrapper;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.MutableCorrelationContext;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactory;
import java.util.concurrent.Callable;

final class CallableWrapperFactory
implements WrapperFactory<Callable> {
    CallableWrapperFactory() {
    }

    @Override
    public Callable wrap(MutableCorrelationContext ctx, Callable instance) {
        return new CallableWrapper(instance, ctx);
    }

    private static class CallableWrapper
    implements Callable {
        private final MutableCorrelationContext correlationContext;
        private final Callable<?> callable;
        private final String correlationId;

        public CallableWrapper(Callable<?> callable, MutableCorrelationContext ctx) {
            this.callable = callable;
            this.correlationContext = ctx;
            this.correlationId = this.correlationContext.getCorrelationId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            String oldCorrelationId = this.correlationContext.getCorrelationId();
            this.setupCorrelationContext(this.correlationId);
            try {
                Object obj = this.callable.call();
                return obj;
            }
            finally {
                this.setupCorrelationContext(oldCorrelationId);
            }
        }

        private void setupCorrelationContext(String correlationId) {
            if (null == correlationId) {
                this.correlationContext.clearCorrelationId();
            } else {
                this.correlationContext.setCorrelationId(correlationId);
            }
        }
    }
}

