/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl.wrapper;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.MutableCorrelationContext;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactory;

final class RunnableWrapperFactory
implements WrapperFactory<Runnable> {
    RunnableWrapperFactory() {
    }

    @Override
    public Runnable wrap(MutableCorrelationContext ctx, Runnable instance) {
        return new RunnableWrapper(instance, ctx);
    }

    private static class RunnableWrapper
    implements Runnable {
        private final MutableCorrelationContext correlationContext;
        private final Runnable runnable;
        private final String correlationId;

        public RunnableWrapper(Runnable runnable, MutableCorrelationContext ctx) {
            this.runnable = runnable;
            this.correlationContext = ctx;
            this.correlationId = ctx.getCorrelationId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldCorrelationId = this.correlationContext.getCorrelationId();
            this.setupCorrelationContext(this.correlationId);
            try {
                this.runnable.run();
            }
            finally {
                this.setupCorrelationContext(oldCorrelationId);
            }
        }

        private void setupCorrelationContext(String correlationId) {
            if (null == correlationId) {
                this.correlationContext.clearCorrelationId();
            } else {
                this.correlationContext.setCorrelationId(correlationId);
            }
        }
    }
}

