/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.beust.jcommander.JCommander;
import com.sap.jpaas.infrastructure.console.ConsoleCommandTypeReporter;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.checker.EuPolicyChecker;
import com.sap.jpaas.infrastructure.console.checker.JavaVersionChecker;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.help.HelpUtilities;
import com.sap.jpaas.infrastructure.console.model.CommandModel;
import com.sap.jpaas.infrastructure.console.model.GroupModel;
import eu.infomas.annotation.AnnotationDetector;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CommandManager {
    public static final String PROGRAM_NAME = System.getProperty("neo.base.command", "neo");
    public static final String UNKNOWN = "unknown";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(CommandManager.class);
    public static final String PROPERTIES_PARAM = "properties file";
    private List<CommandModel> commandModels;
    private Map<String, GroupModel> groupModels;

    public void detectAllCommands() throws IOException {
        ConsoleCommandTypeReporter reporter = new ConsoleCommandTypeReporter();
        new AnnotationDetector((AnnotationDetector.Reporter)reporter).detect();
        this.commandModels = reporter.getCommandModels();
        this.groupModels = reporter.getGroupModels();
        LOGGER.debug("Found [", this.commandModels.size(), "] commands");
        LOGGER.debug("Commands ", this.commandModels.toString());
        LOGGER.debug("Groups ", this.groupModels.keySet());
    }

    public List<CommandModel> getCommandModels() {
        return Collections.unmodifiableList(this.commandModels);
    }

    public Map<String, GroupModel> getGroups() {
        return Collections.unmodifiableMap(this.groupModels);
    }

    public Map<String, String> getJarVersions() {
        TreeMap<String, String> jarVersions = new TreeMap<String, String>();
        for (CommandModel command : this.getCommandModels()) {
            String jarURI;
            if (command.isHidden() || jarVersions.get(jarURI = command.getJarUri()) != null) continue;
            jarVersions.put(jarURI, command.getJarVersion());
        }
        return jarVersions;
    }

    public Map<String, Set<String>> getCommandVersions() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String jarName : this.getJarVersions().keySet()) {
            result.put(jarName, new TreeSet());
        }
        for (CommandModel command : this.getCommandModels()) {
            if (command.isHidden()) continue;
            ((Set)result.get(command.getJarUri())).add(command.getFullCommandName());
        }
        return result;
    }

    public String getPropertyFileLocation(Object command) {
        if (command instanceof PropertiesCommand) {
            return ((PropertiesCommand)command).getPropertyFileLocation();
        }
        LOGGER.debug("Command [", command.getClass(), "] does not support property files");
        return null;
    }

    public void run(String commandName, Object command) throws CommandException {
        JavaVersionChecker.checkJREVersionCompatibility();
        this.run(commandName, command, false);
    }

    public Object runForStructuredOutput(String commandName, Object command) throws CommandException {
        return this.run(commandName, command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object run(String commandName, Object command, boolean structuredOutput) {
        long startTime;
        Object result;
        block6: {
            block5: {
                result = null;
                if (!(command instanceof ConsoleCommand)) break block5;
                ConsoleCommand consoleCommand = (ConsoleCommand)command;
                long time = 0L;
                startTime = 0L;
                LOGGER.info("Starting execution of command [", commandName, "]");
                startTime = time = System.currentTimeMillis();
                try {
                    consoleCommand.init();
                    LOGGER.info("Command [", commandName, "] init() finished for [", System.currentTimeMillis() - time, "] ms");
                    time = System.currentTimeMillis();
                    if (structuredOutput) {
                        result = consoleCommand.runForStructuredOutput();
                    } else {
                        if (command instanceof RemoteCommand) {
                            RemoteCommand remoteCommand = (RemoteCommand)command;
                            EuPolicyChecker.checkLandscapeAndUser(remoteCommand.getHost(), remoteCommand.getUser());
                        }
                        consoleCommand.run();
                    }
                    LOGGER.info("Command [", commandName, "] run() finished for [", System.currentTimeMillis() - time, "] ms");
                }
                catch (Throwable throwable) {
                    time = System.currentTimeMillis();
                    consoleCommand.cleanup();
                    LOGGER.info("Command [", commandName, "] cleanup() finished for [", System.currentTimeMillis() - time, "] ms");
                    throw throwable;
                }
                time = System.currentTimeMillis();
                consoleCommand.cleanup();
                LOGGER.info("Command [", commandName, "] cleanup() finished for [", System.currentTimeMillis() - time, "] ms");
                break block6;
            }
            LOGGER.warn("Command [", command.getClass(), "] does not implement ConsoleCommand");
            throw new CommandException("Command [" + command.getClass() + "] not supported", 143);
        }
        LOGGER.info("Command [", commandName, "] finished successfully for [", System.currentTimeMillis() - startTime, "] ms");
        return result;
    }

    public JCommander getJCommanderInstance(CommandModel commandModel) {
        return this.createJCommander(commandModel);
    }

    public JCommander getJCommanderInstance(List<CommandModel> commands) {
        return this.createJCommander(commands.toArray(new CommandModel[0]));
    }

    private JCommander createJCommander(CommandModel ... commandModels) {
        LOGGER.debug("Creating new JCommander instance");
        JCommander commander = new JCommander();
        commander.setProgramName(PROGRAM_NAME);
        for (CommandModel next : commandModels) {
            LOGGER.debug("Adding command [", next.getFullCommandName(), "]");
            commander.addCommand(next.getFullCommandName(), next.getCommand());
            LOGGER.debug("Adding command [", next.getName(), "]");
            commander.addCommand(next.getName(), next.getCommand());
        }
        return commander;
    }

    public void printHelp(JCommander commander, String commandName, String errorMessage) {
        this.printHelp(commander, commandName, errorMessage, false);
    }

    public void printHelp(JCommander commander, String commandName, String errorMessage, boolean allParameters) {
        this.printErrorMessage(errorMessage);
        if (this.commandModels.size() == 0) {
            System.err.println();
            System.err.println("No commands available");
            return;
        }
        JCommander jCommander = commander = commander == null ? this.getJCommanderInstance(this.commandModels) : commander;
        if (commandName == null || commandName.length() == 0) {
            System.out.println();
            System.out.println("Usage: " + PROGRAM_NAME + " [group:]command [parameters] [properties file]");
            System.out.println();
            System.out.println("Available commands:");
            for (String group : this.groupModels.keySet()) {
                GroupModel groupModel = this.groupModels.get(group);
                if (groupModel.isHidden()) continue;
                System.out.println();
                System.out.println(" --- " + group + " ---");
                for (CommandModel commandModel : groupModel.getCommandModels()) {
                    if (commandModel.isHidden()) continue;
                    System.out.println("  " + commandModel.getName());
                    String descripton = commander.getCommandDescription(commandModel.getFullCommandName());
                    for (String line : descripton.split("\\r?\\n")) {
                        System.out.println("        " + line);
                    }
                }
            }
            System.out.println();
            System.out.println("Use \"" + PROGRAM_NAME + " help [group:]command\" to get help for a particular command");
            System.out.println();
        } else {
            HelpUtilities.printUsage(commander, this.commandModels, commandName, PROGRAM_NAME, PROPERTIES_PARAM, allParameters);
        }
    }

    public void printErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            System.err.println(errorMessage);
            System.err.println();
        }
    }
}

