/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.sap.core.utils.infrastructure.validation.AuthenticationException;
import com.sap.core.utils.sdk.status.SdkRuntimeUndefinedException;
import com.sap.jpaas.infrastructure.console.CommandManager;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.PropertyFileProvider;
import com.sap.jpaas.infrastructure.console.command.CommandParameters;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ExitCode;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import com.sap.jpaas.infrastructure.console.exception.SDKException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.model.CommandModel;
import com.sap.jpaas.infrastructure.console.model.CommandResult;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.util.MessageUtils;
import com.sap.jpaas.infrastructure.console.util.StructuredOutputHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class ConsoleClient {
    public static final String NEO_PROCESS_NAME = "neo.process.name";
    public static final String TOOLS_PAGE = "https://tools.{0}";
    private static final String SPACE = " ";
    private static final String MASKED_PASSWORD = "********";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(ConsoleClient.class);
    private static PrintStream sysOut = System.out;
    private static PrintStream sysErr = System.err;
    private static ByteArrayOutputStream cmdBasfOutStream = new ByteArrayOutputStream();
    private static ByteArrayOutputStream cmdBasfErrStream = new ByteArrayOutputStream();
    private static PrintStream cmdOut = new PrintStream(cmdBasfOutStream);
    private static PrintStream cmdErr = new PrintStream(cmdBasfErrStream);
    private static final String LOGGING_LOCATION = System.getProperty("neo.logging.location", "./log");
    private static final CommandManager manager = new CommandManager();
    private static final int DAYS_TO_KEEP_LOGS = Integer.parseInt(System.getProperty("neo.logging.days", "30"));
    private boolean askingForHelp = false;
    private static final List<String> HELP_PATTERNS = new ArrayList<String>(Arrays.asList("/?", "/h", "/help", "--help", "-?", "-help", "--?"));

    public static void main(String[] args) {
        ConsoleClient.deleteOldLogs();
        new ConsoleClient().run(args);
    }

    private static void deleteOldLogs() {
        String[] fileNames = new File(LOGGING_LOCATION).list();
        if (fileNames != null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, DAYS_TO_KEEP_LOGS * -1);
            long purgeTime = cal.getTimeInMillis();
            for (String fileName : fileNames) {
                File currentFile = new File(LOGGING_LOCATION + File.separator + fileName);
                if (currentFile.isDirectory() || currentFile.lastModified() >= purgeTime || currentFile.delete()) continue;
                LOGGER.debug("File [", currentFile.getAbsolutePath(), "] cannot be deleted");
            }
        }
    }

    public void run(String[] commandLineArguments) {
        Object[] maskedCommandLineArguments = this.getMaskedCommandLineArguments((String[])commandLineArguments.clone());
        String argumentLineReadyToPrint = this.getArgLine((String[])maskedCommandLineArguments);
        LOGGER.info("Arguments:   ", argumentLineReadyToPrint);
        this.detectCommands();
        List<CommandModel> commandModels = manager.getCommandModels();
        JCommander commander = manager.getJCommanderInstance(commandModels);
        String commandName = null;
        CommandResult commandResult = new CommandResult();
        try {
            try {
                commandName = this.getCommandName(commander, commandLineArguments);
            }
            catch (MissingCommandException mce) {
                this.handleMissingCommandException(commandLineArguments, commander, mce);
            }
            if (this.askingForHelp) {
                throw new HelpException();
            }
            CommandModel commandModel = CommandModel.getCommandModelByName(commandName);
            this.validateCommandModel(commander, commandName, commandModel);
            commandResult.setCommand(commandName);
            commandResult.setArgLine(argumentLineReadyToPrint);
            commandResult.setPid(System.getProperties().getProperty(NEO_PROCESS_NAME));
            commander = manager.getJCommanderInstance(commandModel);
            String location = manager.getPropertyFileLocation(commandModel.getCommand());
            if (location != null) {
                commander.setDefaultProvider((IDefaultProvider)new PropertyFileProvider(location));
            }
            LOGGER.debug("Parsing command line arguments ", Arrays.toString(maskedCommandLineArguments));
            commander.parse(commandLineArguments);
            commandResult.setOutput(commandModel.getCommand().getOutput());
            this.executeCommand(commandName, commandResult, commandModel.getCommand());
        }
        catch (IllegalArgumentException e) {
            this.handleCommandException(commandResult, new CommandException(e));
        }
        catch (HelpException he) {
            this.handleHelpException(commander, commandName, commandResult, he);
        }
        catch (CommandException ce) {
            this.handleCommandException(commandResult, ce);
        }
        catch (ParameterValidationException pve) {
            if (maskedCommandLineArguments.length > 0) {
                this.handleParameterValidationException((String[])maskedCommandLineArguments, commander, commandName == null ? maskedCommandLineArguments[0] : commandName, commandResult, pve);
            } else {
                this.handleParameterException(commandResult, pve);
            }
        }
        catch (SDKException sdke) {
            this.handleSDKException(commandResult, sdke);
        }
        catch (ParameterException pe) {
            this.handleParameterException(commandResult, pe);
        }
        catch (Exception e) {
            this.handleException(commandResult, e);
        }
        catch (AuthenticationException authe) {
            SecurityException se = new SecurityException(authe.getMessage(), authe, 110);
            this.handleCommandException(commandResult, se);
        }
        this.printoutAndExit(commandResult, 0);
    }

    private void detectCommands() {
        try {
            manager.detectAllCommands();
        }
        catch (IOException e) {
            LOGGER.info(e, "Cannot detect command");
            System.exit(2);
        }
    }

    private void executeCommand(String commandName, CommandResult commandResult, Object commandObject) {
        if (commandObject instanceof ConsoleCommand) {
            ConsoleCommand consoleCommand = (ConsoleCommand)commandObject;
            if (consoleCommand.getOutput() != null) {
                System.setOut(cmdOut);
                System.setErr(cmdErr);
                if (consoleCommand instanceof RemoteCommand && !((RemoteCommand)consoleCommand).havePassword()) {
                    throw new ValidationException("Password should be set as command argument, when using structured output!");
                }
                Object structuredOutput = manager.runForStructuredOutput(commandName, consoleCommand);
                commandResult.setResult(structuredOutput);
            } else {
                manager.run(commandName, commandObject);
            }
        } else {
            manager.run(commandName, commandObject);
        }
    }

    private void validateCommandModel(JCommander commander, String commandName, CommandModel commandModel) {
        if (commandModel == null || commandModel.getCommand() == null) {
            LOGGER.warn("Command [", commandName, "] not found");
            manager.printHelp(commander, commandName, "Command not found");
            System.exit(2);
        }
    }

    private void handleMissingCommandException(String[] commandLineArguments, JCommander commander, MissingCommandException mce) {
        LOGGER.debug(mce, "No command to execute");
        String command = commander.getParsedCommand();
        if (command == null && commandLineArguments != null && commandLineArguments.length > 0) {
            command = commandLineArguments[0];
        }
        manager.printHelp(commander, command, mce.getMessage());
        System.exit(2);
    }

    private void handleHelpException(JCommander commander, String commandName, CommandResult commandResult, HelpException he) {
        if (he.shouldDisplayHelp()) {
            LOGGER.debug(he, "Command requested help");
            manager.printHelp(commander, commandName, he.getMessage());
            this.printoutAndExit(commandResult, ExitCode.getValidExitCode(he.getExitCode()));
        } else {
            this.handleCommandException(commandResult, he);
        }
    }

    private void handleParameterValidationException(String[] commandLineArguments, JCommander commander, String commandName, CommandResult commandResult, ParameterValidationException pve) {
        LOGGER.debug((Throwable)((Object)pve), "Failed to validate arguments");
        JCommander commandCommander = (JCommander)commander.getCommands().get(commandName);
        List<String> parameterNames = this.getParameterNames(commandCommander.getParameters(), pve);
        String message = MessageUtils.getParameterValidationErrorMessage(commandLineArguments, parameterNames, pve);
        manager.printErrorMessage(MessageUtils.getErrorMessage(new CommandException(message)).toString());
        this.printoutAndExit(commandResult, 40);
    }

    private void handleParameterException(CommandResult commandResult, ParameterException pe) {
        LOGGER.debug(pe, "Failed to validate arguments");
        manager.printErrorMessage(MessageUtils.getErrorMessage(new CommandException(pe.getMessage())).toString());
        this.printoutAndExit(commandResult, 40);
    }

    private void handleException(CommandResult commandResult, Exception e) {
        e.printStackTrace(System.err);
        commandResult.setErrorMsg(e.getMessage());
        this.printoutAndExit(commandResult, 1);
    }

    private List<String> getParameterNames(List<ParameterDescription> parameters, ParameterValidationException pve) {
        String parameterName = pve.getParameter().trim();
        ArrayList<String> names = new ArrayList<String>();
        for (ParameterDescription parameter : parameters) {
            Parameter parameterAnnotation = parameter.getField().getAnnotation(Parameter.class);
            if (!Arrays.asList(parameterAnnotation.names()).contains(parameterName)) continue;
            Collections.addAll(names, parameterAnnotation.names());
            break;
        }
        return names;
    }

    private String getArgLine(String[] commandLineArguments) {
        StringBuilder argLine = new StringBuilder();
        for (int i = 1; i < commandLineArguments.length; ++i) {
            argLine.append(commandLineArguments[i]);
            if (i >= commandLineArguments.length - 1) continue;
            argLine.append(SPACE);
        }
        return argLine.toString();
    }

    private String[] getMaskedCommandLineArguments(String[] commandLineArguments) {
        for (int i = 1; i < commandLineArguments.length; ++i) {
            if (!CommandParameters.CONFIDENTIAL_PARAMETERS.contains(commandLineArguments[i].toLowerCase()) || commandLineArguments.length <= i + 1) continue;
            commandLineArguments[i + 1] = MASKED_PASSWORD;
            ++i;
        }
        return commandLineArguments;
    }

    private void handleCommandException(CommandResult command, CommandException ce) {
        String causeMessage;
        Throwable cause = ce.getCause();
        String string = causeMessage = cause != null ? cause.getMessage() : null;
        if (cause instanceof UnknownHostException) {
            boolean httpsProxyHostSet = System.getProperties().getProperty("https.proxyHost") != null;
            boolean httpProxyHostSet = System.getProperties().getProperty("http.proxyHost") != null;
            StringBuilder errMessage = new StringBuilder();
            errMessage.append("Host [").append(causeMessage).append("] cannot be accessed. ");
            if (!httpsProxyHostSet && !httpProxyHostSet) {
                errMessage.append("HTTP and HTTPS proxy settings not found. ");
            } else if (!httpsProxyHostSet) {
                errMessage.append("HTTPS proxy settings not found. ");
            } else if (!httpProxyHostSet) {
                errMessage.append("HTTP proxy settings not found. ");
            }
            if (!httpsProxyHostSet || !httpProxyHostSet) {
                String sdkPath = new File(System.getProperty("neo.base.location", ".")).getAbsolutePath();
                errMessage.append("Configure your proxy settings as described in the documentation (" + sdkPath + "\\readme.txt)");
            }
            LOGGER.fatal(errMessage);
            System.err.println(errMessage.toString());
            command.setErrorMsg(errMessage.toString());
            this.printoutAndExit(command, 4);
        } else if (cause instanceof SdkRuntimeUndefinedException && cause.getCause() == null) {
            String errMsg = "Your SDK is not supported.Upgrade your SDK via the sdk-upgrade command.";
            System.err.println(errMsg);
            command.setErrorMsg(errMsg);
            LOGGER.fatal(errMsg);
            this.printoutAndExit(command, 3);
        }
        String errorMessage = MessageUtils.getErrorMessage(ce);
        System.err.println();
        System.err.println();
        System.err.println(errorMessage);
        LOGGER.fatal(ce, errorMessage);
        StringBuilder helpMessage = this.getHelpInfoMessage();
        System.err.println(helpMessage);
        command.setErrorMsg(errorMessage.toString());
        this.printoutAndExit(command, ExitCode.getValidExitCode(ce.getExitCode()));
    }

    private void printoutAndExit(CommandResult commandResult, int exitCode) {
        if (commandResult.isOutputSet()) {
            System.setOut(sysOut);
            System.setErr(sysErr);
            commandResult.setCommandOutput(cmdBasfOutStream.toString());
            commandResult.setCommandErrorOutput(cmdBasfErrStream.toString());
            commandResult.setExitCode(exitCode);
            StructuredOutputHelper.printStructuredOutput(commandResult);
        }
        System.exit(exitCode);
    }

    private StringBuilder getHelpInfoMessage() {
        String loggingDir = new File(LOGGING_LOCATION).getAbsolutePath();
        return new StringBuilder("If you need help, provide the output of the command and attach the log directory [").append(loggingDir).append("]");
    }

    private String getCommandName(JCommander commander, String[] commandLineArguments) throws ParameterException {
        if (commandLineArguments.length == 0) {
            throw new ParameterException("No arguments specified. " + DumpHelper.LINE_SEPARATOR + "For help, type: " + CommandManager.PROGRAM_NAME + " help");
        }
        this.askingForHelp = ConsoleClient.isAskingForHelp(commandLineArguments);
        if (this.askingForHelp && commandLineArguments.length < 2) {
            throw new HelpException();
        }
        commander.parseWithoutValidation(commandLineArguments);
        return commander.getParsedCommand();
    }

    public static boolean isAskingForHelp(String[] commandLineArguments) {
        for (String argument : commandLineArguments) {
            if (!HELP_PATTERNS.contains(argument.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static CommandManager getManager() {
        return manager;
    }

    private void handleSDKException(CommandResult commandResult, SDKException sdke) {
        LOGGER.error(sdke, new Object[0]);
        manager.printErrorMessage(sdke.getMessage());
        this.printoutAndExit(commandResult, 3);
    }
}

