/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.beust.jcommander.Parameters;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.model.CommandModel;
import com.sap.jpaas.infrastructure.console.model.GroupModel;
import eu.infomas.annotation.AnnotationDetector;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConsoleCommandTypeReporter
implements AnnotationDetector.TypeReporter {
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(ConsoleCommandTypeReporter.class);
    private final Set<String> commandNames = new HashSet<String>();
    private final List<CommandModel> commandModels = new ArrayList<CommandModel>();
    private final Map<String, GroupModel> groupModels = new TreeMap<String, GroupModel>();

    public List<CommandModel> getCommandModels() {
        return this.commandModels;
    }

    public Map<String, GroupModel> getGroupModels() {
        return this.groupModels;
    }

    public Class<? extends Annotation>[] annotations() {
        return new Class[]{Parameters.class};
    }

    public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
        LOGGER.debug("Found command [", className, "]");
        try {
            Class<?> clazz = Class.forName(className);
            this.traverse(className, clazz);
        }
        catch (NoClassDefFoundError ncdfe) {
            LOGGER.warn(ncdfe, "Cannot find command class [", className + "]");
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warn(cnfe, "Cannot find command class [", className, "]");
        }
        catch (InstantiationException ie) {
            LOGGER.warn(ie, "Cannot instantiate command [", className, "]");
        }
        catch (IllegalAccessException iae) {
            LOGGER.warn(iae, "Command [", className, "] does not have a public constructor");
        }
        catch (ExceptionInInitializerError eiie) {
            LOGGER.warn(eiie, "Command [", className, "] cannot be initialized");
        }
    }

    private void traverse(String className, Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (!this.commandNames.contains(className)) {
            Object command = clazz.newInstance();
            if (command instanceof ConsoleCommand) {
                LOGGER.debug("Obtaining command name and group for [", className, "]");
                CommandModel commandModel = new CommandModel((ConsoleCommand)command);
                if (commandModel.isValid()) {
                    this.processConsoleCommand(className, commandModel);
                    this.commandNames.add(className);
                } else {
                    LOGGER.warn("Command class [", className, "] without name will be ignored.");
                }
            } else {
                LOGGER.warn("Command [", className, "] does not implement ConsoleCommand");
            }
        }
    }

    private void processConsoleCommand(String className, CommandModel commandModel) {
        if (!this.commandModels.contains(commandModel)) {
            this.commandModels.add(commandModel);
            GroupModel groupModel = GroupModel.UNKNOWN;
            if (commandModel.getCommand().getGroup() != null && !commandModel.getCommand().getGroup().trim().isEmpty()) {
                groupModel = this.groupModels.get(commandModel.getCommand().getGroup()) == null ? new GroupModel(commandModel.getCommand().getGroup()) : this.groupModels.get(commandModel.getCommand().getGroup());
            }
            if (this.groupModels.get(groupModel.getName()) == null) {
                this.groupModels.put(groupModel.getName(), groupModel);
            }
            groupModel = this.groupModels.get(groupModel.getName());
            groupModel.addCommandModel(commandModel);
        } else {
            LOGGER.warn("Command [", commandModel.getCommand().getGroup() + ":" + commandModel.getName(), "] already exists. Ignoring class [", className, "]");
        }
    }
}

