/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class ConsoleLogger {
    private Logger logger;

    public static ConsoleLogger getLogger(Class<?> clazz) {
        return new ConsoleLogger(clazz);
    }

    public static ConsoleLogger getLogger(String name) {
        return new ConsoleLogger(name);
    }

    public static ConsoleLogger getLogger(String name, LoggerFactory factory) {
        return new ConsoleLogger(name, factory);
    }

    private ConsoleLogger(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz);
    }

    private ConsoleLogger(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    private ConsoleLogger(String name, LoggerFactory factory) {
        this.logger = Logger.getLogger((String)name, (LoggerFactory)factory);
    }

    public void info(Object ... messages) {
        this.info(null, messages);
    }

    public void info(Throwable t, Object ... messages) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)ConsoleLogger.appendMessages(messages), t);
        }
    }

    public void debug(Object ... messages) {
        this.debug(null, messages);
    }

    public void debug(Throwable t, Object ... messages) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)ConsoleLogger.appendMessages(messages), t);
        }
    }

    public void warn(Object ... messages) {
        this.warn(null, messages);
    }

    public void warn(Throwable t, Object ... messages) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)ConsoleLogger.appendMessages(messages), t);
        }
    }

    public void error(Object ... messages) {
        this.error(null, messages);
    }

    public void error(Throwable t, Object ... messages) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)ConsoleLogger.appendMessages(messages), t);
        }
    }

    public void fatal(Object ... messages) {
        this.fatal(null, messages);
    }

    public void fatal(Throwable t, Object ... messages) {
        if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
            this.logger.fatal((Object)ConsoleLogger.appendMessages(messages), t);
        }
    }

    private static String appendMessages(Object ... messages) {
        StringBuilder message = new StringBuilder();
        for (Object next : messages) {
            message.append(next);
        }
        return message.toString();
    }
}

