/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.ParameterException;
import com.sap.jpaas.infrastructure.console.command.CommandParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class PropertyFileProvider
implements IDefaultProvider {
    private Logger LOGGER;
    protected Properties properties;
    protected File propertyFile;

    public PropertyFileProvider(String fileName) {
        block6: {
            this.LOGGER = Logger.getLogger(PropertyFileProvider.class);
            this.LOGGER.debug((Object)("Properties file: " + fileName));
            if (fileName == null) break block6;
            BufferedReader reader = null;
            try {
                this.properties = new Properties();
                this.propertyFile = new File(fileName);
                reader = new BufferedReader(new FileReader(fileName));
                this.properties.load(reader);
                this.LOGGER.debug((Object)("Loaded properties file [" + fileName + "]"));
            }
            catch (IOException e) {
                try {
                    throw new ParameterException("Could not open properties file: " + fileName);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
            for (String key : this.properties.stringPropertyNames()) {
                if (CommandParameters.CONFIDENTIAL_PARAMS.contains(key)) {
                    throw new ParameterException("Template properties file contains plain text confidential data in [" + key + "] option. Remove the value and use the command argument with the same name instead");
                }
                if (!this.properties.getProperty(key).trim().isEmpty()) continue;
                this.properties.remove(key);
                this.LOGGER.debug((Object)("Key [" + key + "] contains only whitespace characters and will be ignored"));
            }
        }
    }

    public String getDefaultValueFor(String optionName) {
        int index;
        for (index = 0; index < optionName.length() && !Character.isLetterOrDigit(optionName.charAt(index)); ++index) {
        }
        String key = optionName.substring(index);
        String value = this.properties.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

