/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.sap.core.utils.sdk.status.SDKVersion;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.utils.SdkFileUtils;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.PropertyFileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

final class SDKVersionPropertyFileProvider
extends PropertyFileProvider {
    private static final String SDK_STATUS_FILE = "sdkcheck.%s.%s.%s.tmp";
    private static final String UPDATE_DATE = "update.date";
    private static final String UPDATE_VERSION = "update.version";
    private static final String UPDATE_LINK = "update.link";
    private static final String LAST_SDK_STATUS = "last.status";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(SDKVersionPropertyFileProvider.class);

    public SDKVersionPropertyFileProvider(String landscape, String runtime, String version, boolean createFile) {
        super(SDKVersionPropertyFileProvider.initStatusFile(landscape, runtime, version, createFile));
    }

    public SDKVersionPropertyFileProvider(String landscape, String runtime, String version) {
        this(landscape, runtime, version, true);
    }

    public long getLastUpdateDate() {
        long dateValue = 0L;
        try {
            dateValue = Long.parseLong(this.getDefaultValueFor(UPDATE_DATE));
        }
        catch (NumberFormatException ex) {
            LOGGER.debug(ex, "An error occured while parsing date from file. A version vailidity check will still be performed.");
        }
        return dateValue;
    }

    public String getLastStatus() {
        return this.getDefaultValueFor(LAST_SDK_STATUS);
    }

    public String getUpdateLink() {
        return this.getDefaultValueFor(UPDATE_LINK);
    }

    public String getVersion() {
        return this.getDefaultValueFor(UPDATE_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatusFile(String landscape, String runtime, String version, SDKVersionStatus status, String updateTime) {
        FileOutputStream fooStream;
        block7: {
            LOGGER.debug("Updating sdk status file ", this.propertyFile, " after version validity check was performed");
            fooStream = null;
            try {
                String latestStatus;
                String url;
                SDKVersion sdk = status.getSdk();
                if (sdk == null) break block7;
                fooStream = new FileOutputStream(this.getPropertyFile(), false);
                this.properties.setProperty(UPDATE_DATE, updateTime);
                String lastVersion = status.getSdk().getVersion();
                if (lastVersion != null) {
                    this.properties.setProperty(UPDATE_VERSION, lastVersion);
                }
                if ((url = status.getSdk().getDownloadUrl()) != null) {
                    this.properties.setProperty(UPDATE_LINK, url);
                }
                if ((latestStatus = status.getStatus().toString()) != null) {
                    this.properties.setProperty(LAST_SDK_STATUS, latestStatus);
                }
                this.properties.store(fooStream, null);
            }
            catch (IOException ex) {
                try {
                    LOGGER.debug(ex, "An error occured while trying to update ", this.propertyFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fooStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fooStream);
            }
        }
        IOUtils.closeQuietly(fooStream);
    }

    private static String initStatusFile(String landscape, String runtime, String version, boolean createFile) {
        File statusFile = null;
        String path = SdkFileUtils.getTempPath();
        try {
            if (path != null && !(statusFile = new File(path, File.separator + String.format(SDK_STATUS_FILE, landscape, runtime, version))).isFile() && createFile) {
                LOGGER.debug("Attempting to create status file: " + statusFile.getAbsolutePath());
                statusFile.createNewFile();
            }
            LOGGER.debug("Opening file ", path, Character.valueOf(File.separatorChar), SDK_STATUS_FILE);
        }
        catch (SecurityException ex) {
            LOGGER.debug(ex, "An error occured while trying to create temp file in tmp directory");
        }
        catch (IOException ex) {
            LOGGER.debug(ex, "An error occured while trying to create sdk status file in tmp directory");
        }
        return statusFile != null ? statusFile.getAbsolutePath() : null;
    }

    File getPropertyFile() {
        return this.propertyFile;
    }
}

