/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.sap.core.utils.sdk.status.RuntimeType;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.VersionValidityChecker;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class VersionValidityCheckProvider {
    private static final String ERROR_VALIDITY_CHECK_INTERRUPTED = "An error occurred while executing the version validity checker thread";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(VersionValidityCheckProvider.class);
    private Future<SDKVersionStatus> worker;
    private String neoSDKVersion;
    private RuntimeType neoRuntime;
    private String landscape;

    public VersionValidityCheckProvider(String landscape) {
        this.landscape = landscape;
        this.neoSDKVersion = VersionUtilities.getReleaseVersion();
        this.neoRuntime = VersionUtilities.parseRuntime(VersionUtilities.getRuntime(), this.neoSDKVersion);
    }

    public void optimizedVersionValidityCheck() {
        this.startVersionValidityCheck(true);
    }

    public void nonOptimizedVersionValidityCheck() {
        this.startVersionValidityCheck(false);
    }

    public SDKVersionStatus getVersionValidityCheckResult() throws CommandException {
        SDKVersionStatus status = null;
        try {
            if (this.worker != null) {
                status = this.worker.get();
            }
        }
        catch (InterruptedException e) {
            throw new CommandException(ERROR_VALIDITY_CHECK_INTERRUPTED, e);
        }
        catch (ExecutionException e) {
            throw new CommandException(e.getCause().getMessage(), e.getCause());
        }
        return status;
    }

    private void startVersionValidityCheck(boolean opt) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        LOGGER.debug("Starting version validity checker thread...");
        this.worker = executorService.submit(new VersionValidityChecker(this.neoSDKVersion, this.landscape, this.neoRuntime, opt));
        try {
            executorService.shutdown();
            if (!executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                LOGGER.error("Version validity status could not be obtained within 3 seconds. This should not affect the command's execution.");
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug(e, "An error occurred during startup of the version validity checker thread. Task was interrupted.");
        }
    }
}

