/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import com.beust.jcommander.ParameterException;
import com.sap.core.utils.sdk.status.RuntimeType;
import com.sap.core.utils.sdk.status.SDKStatus;
import com.sap.core.utils.sdk.status.SDKVersion;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.status.SDKVersionStatusUtils;
import com.sap.core.utils.sdk.status.SdkRuntimeUndefinedException;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.SDKVersionPropertyFileProvider;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.naming.ServiceUnavailableException;

class VersionValidityChecker
implements Callable<SDKVersionStatus> {
    private static final long THREE_DAYS_IN_MILLIS = TimeUnit.MILLISECONDS.convert(3L, TimeUnit.DAYS);
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(VersionValidityChecker.class);
    private String version;
    private String landscape;
    private RuntimeType neoRuntime;
    private boolean optimized;
    private SDKVersionPropertyFileProvider filePropertiesProvider;

    public VersionValidityChecker(String version, String landscape, RuntimeType neoRuntime, boolean optimized) {
        this.version = version;
        this.landscape = landscape;
        this.neoRuntime = neoRuntime;
        this.optimized = optimized;
    }

    @Override
    public SDKVersionStatus call() throws Exception {
        boolean shouldCheckVersion;
        SDKVersionStatus status = null;
        if (this.version == null || this.neoRuntime == null) {
            status = new SDKVersionStatus();
            status.setStatus(SDKStatus.UNDEFINED);
            LOGGER.error("There was a problem obtaining version or runtime status of your SDK and the status cannot be defined. This should not affect the command's execution.");
            return status;
        }
        try {
            this.filePropertiesProvider = new SDKVersionPropertyFileProvider(this.landscape, this.neoRuntime.getRuntimeUID(), this.version, false);
        }
        catch (ParameterException ex) {
            LOGGER.info("No SDK status file for your configuration was found. Creating a new status file...");
        }
        boolean bl = shouldCheckVersion = this.filePropertiesProvider != null && this.filePropertiesProvider.getPropertyFile() != null ? this.shouldCheckVersion() : true;
        if (this.optimized && !shouldCheckVersion) {
            String lastStatus = this.filePropertiesProvider.getLastStatus();
            String lastVersion = this.filePropertiesProvider.getVersion();
            String lastUpdateLink = this.filePropertiesProvider.getUpdateLink();
            if (lastStatus != null && lastVersion != null && lastUpdateLink != null) {
                status = this.createCachedResponseStatus(lastStatus, lastVersion, lastUpdateLink);
                LOGGER.debug("SDK status provided by status file is ", status.getStatus().toString());
            } else {
                LOGGER.debug("Could not load properties from SDK status file. The file might be corrupted. This should not affect the command's execution.");
                status = this.createNonOptimizedVvcResponse();
            }
        } else {
            status = this.createNonOptimizedVvcResponse();
        }
        return status;
    }

    private SDKVersionStatus createNonOptimizedVvcResponse() throws ExecutionException, ServiceUnavailableException, IOException, SdkRuntimeUndefinedException {
        SDKVersionStatus status = new SDKVersionStatus();
        LOGGER.debug("Currently running SDK version validity check for user SDK version: ", this.version, ", region: ", this.landscape, " and runtime: ", this.neoRuntime);
        status = SDKVersionStatusUtils.determineStatus((String)this.version, (String)this.landscape, (RuntimeType)this.neoRuntime);
        LOGGER.info("Successfully performed version validity check. The returned status is ", status.getStatus());
        if (this.filePropertiesProvider == null) {
            this.filePropertiesProvider = new SDKVersionPropertyFileProvider(this.landscape, this.neoRuntime.getRuntimeUID(), this.version, true);
        }
        if (this.filePropertiesProvider != null && this.filePropertiesProvider.getPropertyFile() != null && this.filePropertiesProvider.getPropertyFile().isFile()) {
            this.filePropertiesProvider.updateStatusFile(this.landscape, this.neoRuntime.getRuntimeUID(), this.version, status, Long.toString(System.currentTimeMillis()));
        }
        return status;
    }

    private SDKVersionStatus createCachedResponseStatus(String lastStatus, String lastVersion, String lastUpdateLink) {
        SDKVersionStatus status = new SDKVersionStatus();
        status.setStatus(SDKStatus.valueOf((String)lastStatus));
        SDKVersion sdkVersion = new SDKVersion();
        sdkVersion.setVersion(lastVersion);
        sdkVersion.setDownloadUrl(lastUpdateLink);
        status.setSdk(sdkVersion);
        return status;
    }

    private boolean shouldCheckVersion() {
        boolean shouldCheckVersion = System.currentTimeMillis() - this.filePropertiesProvider.getLastUpdateDate() > THREE_DAYS_IN_MILLIS;
        LOGGER.debug("Remote call for version validity check will be performed: " + shouldCheckVersion);
        return shouldCheckVersion;
    }
}

