/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.checker;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sap.core.utils.security.logon.LogonUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.Console;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class EuPolicyChecker {
    private static final String ERROR_EMPTY_USER = "The user cannot be null or empty string";
    private static final String REGION = "region";
    private static final String EU_REGION = "eu";
    private static final String WS_ALIAS = "/location";
    private static final String BANNER = "This {0} landscape is operated and supported in European Union (EU) Access mode. As an SAP employee, you must confirm either that you are physically located within the EU or that you have positively verified that EU Access restrictions do not apply in your situation.{1}For details, see https://wiki.wdf.sap.corp/wiki/display/JPaaS/European+Data+Protection+at+a+Glance";
    private static final String QUESTION = "Are you located inside the EU?(yes/no) [Default: no]";
    private static final String POLICIES_VIOLATION_MSG = "This {0} landscape is operated and supported in European Union (EU) Access mode. You cannot proceed!";
    private static final Pattern EU_PATTERN = Pattern.compile("(?:eu\\d+.)?hana.ondemand.com");
    private static final String SAP_USER_NUMBER_PATTERN = "^[c,d,i]{1}\\d+$";

    public static void checkLandscapeAndUser(String host, String user) throws CommandException {
        if (host == null || user == null) {
            return;
        }
        if (EuPolicyChecker.isSapUser(user)) {
            URL url = null;
            try {
                url = new URL(host);
            }
            catch (MalformedURLException e) {
                throw new CommandException(e, 41);
            }
            if (url != null) {
                String region = null;
                try {
                    HttpClient httpClient = LogonUtils.createHttpClientWithoutAuth((String)host);
                    String uri = url.toString() + WS_ALIAS;
                    HttpGet httpGet = new HttpGet(uri);
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                    JsonElement json = new JsonParser().parse(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                    region = json.getAsJsonObject().get(REGION).getAsString();
                }
                catch (Exception e) {
                    EuPolicyChecker.handleWebSericeError(url);
                }
                if (region != null && region.equalsIgnoreCase(EU_REGION)) {
                    EuPolicyChecker.askForEuLocation();
                }
            }
        }
    }

    private static void handleWebSericeError(URL url) {
        if (EU_PATTERN.matcher(url.getHost().toLowerCase()).matches()) {
            EuPolicyChecker.askForEuLocation();
        }
    }

    private static void askForEuLocation() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available", 166);
        }
        String formattedBanner = MessageFormat.format(BANNER, "SAP Cloud Platform", DumpHelper.LINE_SEPARATOR);
        String answer = cons.readLine("%s", formattedBanner + " " + QUESTION);
        if (answer == null || !answer.equalsIgnoreCase("yes") && !answer.equalsIgnoreCase("y")) {
            throw new CommandException(MessageFormat.format(POLICIES_VIOLATION_MSG, "SAP Cloud Platform"), 111);
        }
    }

    static boolean isSapUser(String user) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException(ERROR_EMPTY_USER);
        }
        return EuPolicyChecker.isSapUserNumber(user) || EuPolicyChecker.isSapMail(user);
    }

    private static boolean isSapUserNumber(String user) {
        return user.matches(SAP_USER_NUMBER_PATTERN);
    }

    private static boolean isSapMail(String user) {
        return user.endsWith("@sap.com");
    }
}

