/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.checker;

import com.sap.jpaas.infrastructure.console.util.DumpHelper;

public class JavaVersionChecker {
    private static final String UNDERSCORE = "_";
    private static final String DASH = "-";
    private static final String DOT = "\\.";
    private static final String MIN_SUPPORTED_JAVA_VERSION = "1.7.0";
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String UNSUPPORTED_JAVA_VERSION = "Currently used Java version \"%s\" is not supported. The console tools may not work properly. Consider upgrading your JRE.";

    public static void checkJREVersionCompatibility() {
        String javaVersion = System.getProperty(JAVA_VERSION_PROPERTY);
        String javaProductVersion = JavaVersionChecker.getJavaProductVersion(javaVersion);
        if (JavaVersionChecker.compareJavaVersions(javaProductVersion, MIN_SUPPORTED_JAVA_VERSION) < 0) {
            DumpHelper.dumpErrorMessage(String.format(UNSUPPORTED_JAVA_VERSION, javaVersion));
        }
    }

    private static int compareJavaVersions(String currentJavaVersion, String minSupportedJavaVersion) {
        String[] currentJavaVersionParts = currentJavaVersion.split(DOT);
        String[] minSupportedJavaVersionParts = minSupportedJavaVersion.split(DOT);
        int length = Math.max(currentJavaVersionParts.length, minSupportedJavaVersionParts.length);
        for (int i = 0; i < length; ++i) {
            try {
                int minSupportedJavaVersionPart;
                int currentJavaVersionPart = i < currentJavaVersionParts.length ? Integer.parseInt(currentJavaVersionParts[i]) : 0;
                int n = minSupportedJavaVersionPart = i < minSupportedJavaVersionParts.length ? Integer.parseInt(minSupportedJavaVersionParts[i]) : 0;
                if (currentJavaVersionPart < minSupportedJavaVersionPart) {
                    return -1;
                }
                if (currentJavaVersionPart <= minSupportedJavaVersionPart) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    private static String getJavaProductVersion(String javaVersion) {
        String javaProductVersion = null;
        if (javaVersion.contains(UNDERSCORE)) {
            javaProductVersion = javaVersion.split(UNDERSCORE)[0];
        } else if (javaVersion.contains(DASH)) {
            javaProductVersion = javaVersion.split(DASH)[0];
        }
        return javaProductVersion != null ? javaProductVersion : javaVersion;
    }
}

