/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.command;

import com.beust.jcommander.Parameter;
import com.sap.core.utils.infrastructure.validation.SACNameValidator;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.validator.ApplicationValidator;
import com.sap.jpaas.infrastructure.console.validator.ComponentValidator;
import java.text.MessageFormat;

public abstract class ComponentCommand<T>
extends AccountCommand<T> {
    private static final String APPLICATION_ACCOUNT_NAMES = "{0}{1}";
    private static final String THE_LENGTH_OF_ACCOUNT_NAME_APPLICATION_NAME_MESSAGE = "The length of subaccount technical name + application name should not exceed 30 symbols ({0})";
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy", validateWith=ApplicationValidator.class)
    protected String application;
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=ComponentValidator.class, hidden=true)
    protected String component = "web";

    @Override
    public void init() {
        super.init();
        String accountApplicationNames = MessageFormat.format(APPLICATION_ACCOUNT_NAMES, this.application, this.account);
        if (!SACNameValidator.isShortURLValid((String)accountApplicationNames)) {
            throw new ValidationException(MessageFormat.format(THE_LENGTH_OF_ACCOUNT_NAME_APPLICATION_NAME_MESSAGE, accountApplicationNames.length()));
        }
    }

    public String getApplication() {
        return this.application == null ? null : this.application.toLowerCase();
    }

    public String getComponent() {
        return this.component == null ? null : this.component.toLowerCase();
    }
}

