/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.validator.StructuredOutputParameterValidator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ConsoleCommand<T> {
    @Parameter(names={"-output", "--output"}, description="Structured output from commands", validateWith=StructuredOutputParameterValidator.class, hidden=true)
    protected String output;
    @Parameter(names={"-?", "-help", "--help", "--?"}, description="Help", hidden=true)
    protected boolean help;

    public String getOutput() {
        return this.output;
    }

    public abstract void init() throws CommandException;

    public abstract void run() throws CommandException;

    public abstract void cleanup() throws CommandException;

    public abstract String getName();

    public abstract String getGroup();

    public T runForStructuredOutput() throws CommandException {
        this.run();
        return null;
    }

    public String getExample() {
        return null;
    }

    protected void copyParameterValuesFrom(ConsoleCommand<?> otherCommand) throws CommandException {
        try {
            for (Field field : ConsoleCommand.getAllFields(this.getClass())) {
                if (field.getAnnotation(Parameter.class) != null) {
                    this.copyParameterValue(field, otherCommand);
                }
                if (field.getAnnotation(ParametersDelegate.class) == null) continue;
                this.copyParameterDelegateValue(field, otherCommand);
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandException(e);
        }
    }

    private void copyParameterValue(Field paramField, ConsoleCommand<?> otherCommand) throws IllegalAccessException, CommandException {
        Object[] paramNames = paramField.getAnnotation(Parameter.class).names();
        for (Field otherField : ConsoleCommand.getAllFields(otherCommand.getClass())) {
            Object[] otherParamNames;
            Parameter paramAnnotation = otherField.getAnnotation(Parameter.class);
            if (paramAnnotation == null || !Arrays.equals(paramNames, otherParamNames = paramAnnotation.names())) continue;
            otherField.setAccessible(true);
            Object paramValue = otherField.get(otherCommand);
            paramField.setAccessible(true);
            paramField.set(this, paramValue);
            return;
        }
        throw new CommandException("No suitable source field in " + otherCommand.getClass().getName() + " for parameter field " + paramField.getName() + " in " + this.getClass().getName() + ".");
    }

    private void copyParameterDelegateValue(Field paramField, ConsoleCommand<?> otherCommand) throws IllegalAccessException, CommandException {
        Class<?> delegateClass = paramField.getType();
        for (Field otherField : ConsoleCommand.getAllFields(otherCommand.getClass())) {
            ParametersDelegate paramDelegateAnnotation = otherField.getAnnotation(ParametersDelegate.class);
            if (paramDelegateAnnotation == null || !otherField.getType().equals(delegateClass)) continue;
            otherField.setAccessible(true);
            Object paramValue = otherField.get(otherCommand);
            paramField.setAccessible(true);
            paramField.set(this, paramValue);
            return;
        }
        throw new CommandException("No suitable source field in " + otherCommand.getClass().getName() + " for parameters delegate field of type " + delegateClass.getName() + " in " + this.getClass().getName() + ".");
    }

    public void setParameterValue(String[] paramNames, Object value) throws CommandException {
        try {
            Field paramField = this.getFieldForParameter(paramNames);
            paramField.setAccessible(true);
            paramField.set(this, value);
        }
        catch (IllegalAccessException e) {
            throw new CommandException(e);
        }
    }

    public Object getParameterValue(String[] paramNames) throws CommandException {
        try {
            Field paramField = this.getFieldForParameter(paramNames);
            paramField.setAccessible(true);
            return paramField.get(this);
        }
        catch (IllegalAccessException e) {
            throw new CommandException(e);
        }
    }

    private Field getFieldForParameter(String[] paramNames) throws CommandException {
        for (Field field : ConsoleCommand.getAllFields(this.getClass())) {
            Parameter paramAnnotation = field.getAnnotation(Parameter.class);
            if (paramAnnotation == null || !Arrays.equals(paramNames, paramAnnotation.names())) continue;
            return field;
        }
        throw new CommandException("Field for parameter " + Arrays.toString(paramNames) + " not found.");
    }

    public void setParamDelegateValue(Class<?> paramDelegateClass, Object value) throws CommandException {
        try {
            Field paramField = this.getFieldForParamDelegate(paramDelegateClass);
            paramField.setAccessible(true);
            paramField.set(this, value);
        }
        catch (IllegalAccessException e) {
            throw new CommandException(e);
        }
    }

    public Object getParamDelegateValue(Class<?> paramDelegateClass) throws CommandException {
        try {
            Field paramField = this.getFieldForParamDelegate(paramDelegateClass);
            paramField.setAccessible(true);
            return paramField.get(this);
        }
        catch (IllegalAccessException e) {
            throw new CommandException(e);
        }
    }

    private Field getFieldForParamDelegate(Class<?> paramDelegateClass) throws CommandException {
        for (Field field : ConsoleCommand.getAllFields(this.getClass())) {
            ParametersDelegate paramDelegateAnnotation = field.getAnnotation(ParametersDelegate.class);
            if (paramDelegateAnnotation == null || !field.getDeclaringClass().equals(paramDelegateClass)) continue;
            return field;
        }
        throw new CommandException("Field for parameter delegate of type " + paramDelegateClass.getName() + " not found.");
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            allFields.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return allFields;
    }
}

