/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.jpaas.infrastructure.console.checker.PasswordChecker;
import com.sap.jpaas.infrastructure.console.command.UnsecuredRemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.client.HttpClient;

public abstract class RemoteCommand<T>
extends UnsecuredRemoteCommand<T> {
    @Parameter(names={"-u", "-user", "--user"}, description="Email or SAP ID (SCN) user name of your user")
    protected String user;
    @Deprecated
    @Parameter(names={"-p", "-password", "--password"}, description="Password of your user. We recommend that you enter it only when prompted, and not explicitly as a parameter in a properties file or the command line.")
    protected String password;

    @Override
    public void init() throws CommandException {
        this.initWithNoPasswordCheck();
    }

    public void initWithNoPasswordCheck() {
        super.initWithHostOnlyCheck();
        try {
            CheckHelper.checkArgSpecified("-u", "--user", this.user, "Provide user name or e-mail to login to specified host");
        }
        catch (ParameterException pe) {
            throw new CommandException(pe, 14);
        }
    }

    @Deprecated
    public void askForPassword() {
        if (this.user != null) {
            this.password = PasswordChecker.checkPassword(this.password);
        }
        CheckHelper.checkArgSpecified("-p", "--password", this.password);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (!this.havePassword()) {
            this.askForPassword();
        }
        return this.password;
    }

    public boolean havePassword() {
        return this.password != null;
    }

    @Override
    protected HttpClient getHttpClient(String alias, int socketTimeout) throws ValidationException {
        HttpClient result = null;
        try {
            result = LandscapeHostValidator.getHttpClient((URL)new URL(this.host), (String)alias, (int)socketTimeout, (String)this.getUser(), (String)this.getPassword(), (boolean)true);
        }
        catch (HostValidationException e) {
            throw new ValidationException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new ValidationException(e);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        return result;
    }
}

