/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.status.SdkRuntimeUndefinedException;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.VersionValidityCheckProvider;
import com.sap.jpaas.infrastructure.console.command.PropertiesCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.HostValidator;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.ServiceUnavailableException;
import org.apache.http.client.HttpClient;

public abstract class UnsecuredRemoteCommand<T>
extends PropertiesCommand<T> {
    public static final String MSG_SDK_NOT_SUPPORTED = "Your SDK is not supported.";
    public static final String MSG_UPGRADE_SDK = "Upgrade your SDK via the sdk-upgrade command.";
    private static final String SDK_VERSION_APPLY_HOTFIX_MSG = "Your current SDK version is \"%s\" and there is a hotfix available. It's highly recommended to update your SDK to version \"%s\".";
    private static final String NOT_SUPPORTED_SDK_VERSION_MSG = "Your SDK version \"%s\" is no longer supported. The latest version is \"%s\" and upgrade is highly recommended.";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(UnsecuredRemoteCommand.class);
    @Parameter(names={"-h", "-host", "--host"}, description="Region host on which you execute the command", validateWith=HostValidator.class)
    protected String host;

    @Override
    public void init() throws CommandException {
        this.initWithHostOnlyCheck();
    }

    public void initWithHostOnlyCheck() {
        try {
            CheckHelper.checkArgSpecified("-h", "--host", this.host, "Provide region host");
        }
        catch (ParameterException pe) {
            throw new CommandException(pe, 11);
        }
        this.performVersionValidityCheck();
        this.host = HostValidator.addHttpsScheme(this.host.toLowerCase());
    }

    private void performVersionValidityCheck() {
        SDKVersionStatus status;
        block12: {
            status = null;
            try {
                status = this.blockingOptimizedCheck(this.host);
            }
            catch (CommandException ex) {
                Throwable cause = ex.getCause();
                if (cause != null && cause instanceof SdkRuntimeUndefinedException && cause.getCause() == null) {
                    LOGGER.info("SDK runtime version is not supported.");
                    DumpHelper.dumpWarningMessage(MSG_SDK_NOT_SUPPORTED);
                    DumpHelper.dumpWarningMessage(MSG_UPGRADE_SDK);
                }
                if (cause != null && cause instanceof ServiceUnavailableException && this.host != "hana.ondemand.com") {
                    LOGGER.info("There is no tools page available on host ", this.host, ". The default tools page on host ", "hana.ondemand.com", " will be used instead. This is expected behaviour as some hosts do not have corresponding tools pages");
                    try {
                        status = this.blockingOptimizedCheck("hana.ondemand.com");
                    }
                    catch (CommandException e) {
                        cause = e.getCause();
                        if (cause != null && cause instanceof SdkRuntimeUndefinedException && cause.getCause() == null) {
                            LOGGER.info("SDK runtime version is not supported.");
                            DumpHelper.dumpWarningMessage(MSG_SDK_NOT_SUPPORTED);
                            DumpHelper.dumpWarningMessage(MSG_UPGRADE_SDK);
                            break block12;
                        }
                        LOGGER.debug(e, e.getMessage());
                        LOGGER.info("Version validity check was not successful. This should not affect the command's execution");
                    }
                }
                LOGGER.debug(ex, ex.getMessage());
                LOGGER.info("Version validity check was not successful. This should not affect the command's execution");
            }
        }
        if (status != null) {
            LOGGER.info("Version validity check is completed");
            String version = VersionUtilities.getReleaseVersion();
            switch (status.getStatus()) {
                case NOT_SUPPORTED: {
                    DumpHelper.dumpWarningMessage(String.format(NOT_SUPPORTED_SDK_VERSION_MSG, version, status.getSdk().getVersion()));
                    break;
                }
                case HOTFIX_AVAILABLE: {
                    DumpHelper.dumpWarningMessage(String.format(SDK_VERSION_APPLY_HOTFIX_MSG, version, status.getSdk().getVersion()));
                    break;
                }
            }
        }
    }

    private SDKVersionStatus blockingOptimizedCheck(String host) throws CommandException {
        VersionValidityCheckProvider instance = new VersionValidityCheckProvider(HostValidator.removeHttpsScheme(host.toLowerCase()));
        instance.optimizedVersionValidityCheck();
        SDKVersionStatus status = instance.getVersionValidityCheckResult();
        return status;
    }

    public String getHost() {
        return this.host;
    }

    protected HttpClient getHttpClient() throws ValidationException {
        return this.getHttpClient("/", 20000);
    }

    protected HttpClient getHttpClient(String alias, int socketTimeout) throws ValidationException {
        HttpClient result = null;
        try {
            result = LandscapeHostValidator.getHttpClient((URL)new URL(this.host), (String)alias, (int)socketTimeout, null, null, (boolean)true);
        }
        catch (HostValidationException e) {
            throw new ValidationException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new ValidationException(e);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        return result;
    }
}

