/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.converter;

import com.beust.jcommander.IStringConverter;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public class URLParameterConverter
implements IStringConverter<String> {
    Logger LOGGER = Logger.getLogger(URLParameterConverter.class);

    public String convert(String source) {
        try {
            new URL(source);
        }
        catch (MalformedURLException e) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("Invalid URL [" + source + "]"));
            }
            return source;
        }
        String decodedURL = this.decodeURL(source);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Decoded [" + source + "] to [" + decodedURL + "]"));
        }
        return decodedURL;
    }

    private String decodeURL(String source) {
        try {
            return URLDecoder.decode(source.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
        }
        catch (UnsupportedEncodingException e) {
            DumpHelper.dumpWarningMessage("URL [" + source + "] will be decoded with default JVM encoding");
            return URLDecoder.decode(source.replace("+", "%2B")).replace("%2B", "+");
        }
    }
}

