/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.exception;

public class ExitCode {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int COMMAND_NOT_FOUND = 2;
    public static final int UNSUPPORTED_SDK = 3;
    public static final int NETWORK_PROBLEM = 4;
    public static final int MISSING_PARAMETER = 10;
    public static final int MISSING_HOST_NAME = 11;
    public static final int MISSING_ACCOUNT_NAME = 12;
    public static final int MISSING_APPLICATION_NAME = 13;
    public static final int MISSING_USER_NAME = 14;
    public static final int VALIDATION_ERROR = 40;
    public static final int VALIDATION_HOST_NAME_ERROR = 41;
    public static final int VALIDATION_ACCOUNT_NAME_ERROR = 42;
    public static final int VALIDATION_APPLICATION_NAME_ERROR = 43;
    public static final int WRONG_USER_NAME_OR_PASSWORD = 110;
    public static final int SECURITY_VIOLATION_ERROR = 111;
    public static final int FRONTEND_ERROR = 166;
    public static final int BACKEND_ERROR = 210;
    public static final int RANGE_INVALID = -1;
    public static final int RANGE_GENERAL_ERRORS = 0;
    public static final int RANGE_MISSING_PARAMETER = 1;
    public static final int RANGE_VALIDATION = 2;
    public static final int RANGE_SECURITY = 3;
    public static final int RANGE_FRONTEND = 4;
    public static final int RANGE_BACKEND = 5;

    public static int getRange(int exitCode) {
        int result = -1;
        if (exitCode >= 1 && exitCode <= 9) {
            result = 0;
        } else if (exitCode >= 10 && exitCode <= 39) {
            result = 1;
        } else if (exitCode >= 40 && exitCode <= 109) {
            result = 2;
        } else if (exitCode >= 110 && exitCode <= 126) {
            result = 3;
        } else if (exitCode >= 166 && exitCode <= 209) {
            result = 4;
        } else if (exitCode >= 210 && exitCode <= 254) {
            result = 5;
        }
        return result;
    }

    public static int getValidExitCode(int exitCode) {
        int result = exitCode;
        if (ExitCode.getRange(exitCode) == -1) {
            result = 1;
        }
        return result;
    }
}

