/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.help;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.sap.jpaas.infrastructure.console.command.CommandParameters;
import com.sap.jpaas.infrastructure.console.help.ordering.Group;
import com.sap.jpaas.infrastructure.console.help.ordering.GroupOrder;
import com.sap.jpaas.infrastructure.console.help.ordering.GroupsOrder;
import com.sap.jpaas.infrastructure.console.help.ordering.ParameterOrder;
import com.sap.jpaas.infrastructure.console.model.CommandModel;
import com.sap.jpaas.infrastructure.console.spell.LevensteinEditDistance;
import com.sap.jpaas.infrastructure.console.spell.SuggestEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HelpUtilities {
    static final String LINE_SEPARATOR_FORMATTER = "  --- %s ---";
    private static final String SPLIT_STRING = "\\s*,\\s*";
    private static final SuggestEngine suggestEngine = new SuggestEngine(new LevensteinEditDistance());

    public static void printUsage(JCommander commander, List<CommandModel> commandModels, String commandName, String programName, String propertiesParam, boolean allParameters) {
        CommandModel commandModel = CommandModel.getCommandModelByName(commandName);
        if (commandModel != null && !commandModel.isHidden()) {
            JCommander cmdCommander = (JCommander)commander.getCommands().get(commandName);
            List parameters = cmdCommander.getParameters();
            List<GroupOrder> groupsOrder = HelpUtilities.getGroupsOrder(parameters);
            TreeMap<GroupOrder, List<ParameterOrder>> parameterInfo = new TreeMap<GroupOrder, List<ParameterOrder>>();
            TreeMap<GroupOrder, List<ParameterOrder>> genericParameterInfo = new TreeMap<GroupOrder, List<ParameterOrder>>();
            int maxParameterLength = 0;
            for (ParameterDescription parameterDescription : parameters) {
                String concatenatedParamList;
                Parameter parameterAnnotation = parameterDescription.getField().getAnnotation(Parameter.class);
                if (parameterAnnotation.hidden() && !allParameters) continue;
                ArrayList<String> parametersList = new ArrayList<String>();
                ArrayList<String> genericParametersList = new ArrayList<String>();
                HelpUtilities.fillParametersLists(parameterDescription, parametersList, genericParametersList);
                Group groupAnnotation = parameterDescription.getField().getAnnotation(Group.class);
                if (parametersList.size() != 0) {
                    concatenatedParamList = HelpUtilities.getConcatenatedParamList(parametersList);
                    HelpUtilities.putParameterInfo(parameterInfo, groupsOrder, concatenatedParamList, parameterDescription.getDescription(), groupAnnotation);
                    maxParameterLength = Math.max(maxParameterLength, concatenatedParamList.length());
                }
                if (genericParametersList.size() == 0) continue;
                concatenatedParamList = HelpUtilities.getConcatenatedParamList(genericParametersList);
                HelpUtilities.putParameterInfo(genericParameterInfo, groupsOrder, concatenatedParamList, parameterDescription.getDescription(), groupAnnotation);
                maxParameterLength = Math.max(maxParameterLength, concatenatedParamList.length());
            }
            ParameterOrder.setParameterFormatStringMaxLength(maxParameterLength);
            HelpUtilities.printHelpMessage(cmdCommander, commandModels, commandName, commander.getCommandDescription(commandName), programName, parameterInfo, genericParameterInfo);
        } else {
            HelpUtilities.printCommandNotFoundMessage(commandModels, commandName);
        }
    }

    private static List<GroupOrder> getGroupsOrder(List<ParameterDescription> parameters) {
        ArrayList<GroupOrder> groupsOrder = new ArrayList<GroupOrder>();
        List<String> allDefinedGroups = null;
        GroupsOrder groupsOrderAnnotation = null;
        if (!parameters.isEmpty()) {
            for (ParameterDescription parameter : parameters) {
                if (parameter != null && (groupsOrderAnnotation = parameter.getObject().getClass().getAnnotation(GroupsOrder.class)) != null) break;
            }
            allDefinedGroups = HelpUtilities.findAllDefinedGroups(parameters);
            Collections.sort(allDefinedGroups);
        }
        int order = 0;
        if (groupsOrderAnnotation != null) {
            for (String group : groupsOrderAnnotation.value()) {
                groupsOrder.add(new GroupOrder(group, order++));
            }
        }
        HelpUtilities.addMissingGroups(groupsOrder, allDefinedGroups, order);
        groupsOrder.add(new GroupOrder("zz_default_group", groupsOrder.size()));
        return groupsOrder;
    }

    private static void addMissingGroups(List<GroupOrder> groupsOrder, List<String> allDefinedGroups, int currentOrder) {
        if (allDefinedGroups != null) {
            for (String group : allDefinedGroups) {
                if (groupsOrder.contains(new GroupOrder(group))) continue;
                groupsOrder.add(new GroupOrder(group, currentOrder++));
            }
        }
    }

    private static List<String> findAllDefinedGroups(List<ParameterDescription> parameters) {
        ArrayList<String> allDefinedGroups = new ArrayList<String>();
        for (ParameterDescription parameter : parameters) {
            Group groupAnnotation = parameter.getField().getAnnotation(Group.class);
            if (groupAnnotation == null) continue;
            allDefinedGroups.add(groupAnnotation.group());
        }
        return allDefinedGroups;
    }

    private static void fillParametersLists(ParameterDescription parameterDescription, List<String> parameters, List<String> genericParameters) {
        String[] parameterNames = parameterDescription.getNames().split(SPLIT_STRING);
        boolean areGenericParams = true;
        for (String parameterName : parameterNames) {
            String paramName = parameterName.trim();
            areGenericParams &= CommandParameters.GENERIC_PARAMS.contains(paramName);
        }
        for (String paramName : parameterNames) {
            if (!(paramName = paramName.trim()).startsWith("--") && (!paramName.startsWith("-") || paramName.length() != 2)) continue;
            if (areGenericParams) {
                genericParameters.add(paramName);
                continue;
            }
            parameters.add(paramName);
        }
    }

    private static String getConcatenatedParamList(List<String> parametersList) {
        String concatenatedParameterList = parametersList.toString();
        concatenatedParameterList = concatenatedParameterList.substring(1, concatenatedParameterList.length() - 1);
        return concatenatedParameterList;
    }

    private static void putParameterInfo(Map<GroupOrder, List<ParameterOrder>> parameterInfo, List<GroupOrder> groupsOrder, String parameterList, String description, Group annotation) {
        GroupOrder groupOrder = HelpUtilities.getGroupOrder(groupsOrder, annotation);
        if (!parameterInfo.containsKey(groupOrder)) {
            parameterInfo.put(groupOrder, new ArrayList());
        }
        parameterInfo.get(groupOrder).add(new ParameterOrder(parameterList, description, HelpUtilities.getOrder(annotation)));
    }

    private static GroupOrder getGroupOrder(List<GroupOrder> groupsOrder, Group annotation) {
        String group = HelpUtilities.getGroup(annotation);
        int order = groupsOrder.indexOf(new GroupOrder(group));
        GroupOrder groupOrder = new GroupOrder(group, order);
        return groupOrder;
    }

    private static String getGroup(Group annotation) {
        return annotation != null ? annotation.group() : "zz_default_group";
    }

    private static int getOrder(Group annotation) {
        return annotation != null ? annotation.rank() : Integer.MAX_VALUE;
    }

    private static void printHelpMessage(JCommander commander, List<CommandModel> commandModels, String commandName, String commandDescription, String programName, Map<GroupOrder, List<ParameterOrder>> parameterInfo, Map<GroupOrder, List<ParameterOrder>> genericParameterInfo) {
        CommandModel commandModel = CommandModel.getCommandModelByName(commandName);
        if (commandModel.isHidden()) {
            HelpUtilities.printCommandNotFoundMessage(commandModels, commandName);
        } else {
            String commandExample;
            System.out.println(commandDescription);
            System.out.println();
            System.out.println("Usage: " + programName + " " + commandName + " [parameters]");
            HelpUtilities.printParametersInfo(parameterInfo);
            HelpUtilities.printParametersInfo(genericParameterInfo, String.format(LINE_SEPARATOR_FORMATTER, "generic parameters"));
            String mainParamDescription = commander.getMainParameterDescription();
            if (mainParamDescription != null && mainParamDescription.length() > 0) {
                System.out.println();
                System.out.println(String.format(LINE_SEPARATOR_FORMATTER, "properties file"));
                System.out.println("   " + mainParamDescription);
            }
            if ((commandExample = commandModel.getCommand().getExample()) != null && !commandExample.isEmpty()) {
                System.out.println();
                System.out.println(String.format(LINE_SEPARATOR_FORMATTER, "example"));
                System.out.println(commandExample);
            }
            System.out.println();
        }
    }

    private static void printParametersInfo(Map<GroupOrder, List<ParameterOrder>> parameters, String group) {
        if (!parameters.isEmpty()) {
            System.out.println();
            System.out.println(group);
            HelpUtilities.printParametersInfo(parameters);
        }
    }

    private static void printParametersInfo(Map<GroupOrder, List<ParameterOrder>> parameterInfo) {
        if (!parameterInfo.isEmpty()) {
            for (GroupOrder groupOrder : parameterInfo.keySet()) {
                List<ParameterOrder> groupParameters = parameterInfo.get(groupOrder);
                Collections.sort(groupParameters);
                boolean defaultGroup = groupOrder.getGroup().equals("zz_default_group");
                if (!defaultGroup) {
                    System.out.println(String.format(LINE_SEPARATOR_FORMATTER, groupOrder));
                }
                for (ParameterOrder parameter : groupParameters) {
                    System.out.println(parameter);
                }
                if (defaultGroup) continue;
                System.out.println();
            }
        }
    }

    private static void printCommandNotFoundMessage(List<CommandModel> commandModels, String commandName) {
        System.err.println();
        System.err.println("Command [" + commandName + "] not found");
        List<String> suggestions = suggestEngine.didYouMean(commandName, CommandModel.getVisibleCommandNames(commandModels));
        if (suggestions.size() > 0) {
            System.err.println();
            System.err.println("Did you mean one of these?");
            for (String suggestion : suggestions) {
                System.err.println("\t" + suggestion);
            }
        }
        System.err.println();
    }
}

