/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.help.ordering;

public class ParameterOrder
implements Comparable<ParameterOrder> {
    private static final int DEFAULT_PARAM_LENGTH = 20;
    private static String formatString = ParameterOrder.getFormatString(20);
    private String parameter;
    private String description;
    private int rank;

    public static void setParameterFormatStringMaxLength(int parameterLength) {
        formatString = ParameterOrder.getFormatString(parameterLength);
    }

    private static String getFormatString(int paramLength) {
        return "   %-" + paramLength + "s   %s";
    }

    public ParameterOrder(String parameter, String description, int rank) {
        this.parameter = parameter;
        this.description = description;
        this.rank = rank;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(ParameterOrder that) {
        int result = this.getRank() - that.getRank();
        if (result == 0) {
            result = this.getParameter().compareTo(that.getParameter());
        }
        return result;
    }

    public String toString() {
        return String.format(formatString, this.getParameter(), this.getDescription());
    }
}

