/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.model;

import com.sap.jpaas.infrastructure.console.ConsoleClient;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.model.GroupModel;
import com.sap.jpaas.infrastructure.console.model.Hidden;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CommandModel
implements Comparable<CommandModel> {
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(CommandModel.class);
    private ConsoleCommand<?> command;
    private String name;
    private GroupModel group;
    private String fullCommandName;
    private boolean isHidden;
    private String jarVersion;
    private String commandVersion;
    private String resourceURL;

    public static CommandModel getCommandModelByName(String commandName) {
        CommandModel found = null;
        List<CommandModel> commandModels = ConsoleClient.getManager().getCommandModels();
        for (CommandModel next : commandModels) {
            if (!next.getFullCommandName().equals(commandName) && !next.getName().equals(commandName)) continue;
            found = next;
            break;
        }
        return found;
    }

    public static Collection<String> getCommandNames(List<CommandModel> commandModels) {
        HashSet<String> commandNames = new HashSet<String>();
        for (CommandModel next : commandModels) {
            commandNames.add(next.getFullCommandName());
            commandNames.add(next.getName());
        }
        return commandNames;
    }

    public static Collection<String> getVisibleCommandNames(Collection<CommandModel> commandModels) {
        HashSet<String> visibleCommands = new HashSet<String>();
        for (CommandModel next : commandModels) {
            if (next.isHidden()) continue;
            visibleCommands.add(next.getFullCommandName());
            visibleCommands.add(next.getName());
        }
        return visibleCommands;
    }

    private static boolean isNotEmpty(String property) {
        return property != null && !property.trim().isEmpty();
    }

    public CommandModel(ConsoleCommand<?> command) {
        this.command = command;
        this.isHidden = command.getClass().getAnnotation(Hidden.class) != null;
    }

    public ConsoleCommand<?> getCommand() {
        return this.command;
    }

    public String getName() {
        if (this.name == null && CommandModel.isNotEmpty(this.getCommand().getName())) {
            this.name = this.getCommand().getName();
        }
        return this.name;
    }

    public GroupModel getGroup() {
        if (this.group == null) {
            Map<String, GroupModel> groups = ConsoleClient.getManager().getGroups();
            if (CommandModel.isNotEmpty(this.command.getGroup())) {
                this.group = groups.get(this.command.getGroup().trim());
            } else {
                LOGGER.warn("Group not found for command [", this.name, "]. Using [", "unknown", "]");
                this.group = GroupModel.UNKNOWN;
            }
        }
        return this.group;
    }

    public void setGroup(GroupModel groupModel) {
        this.group = groupModel;
    }

    public String getFullCommandName() {
        if (this.fullCommandName == null) {
            this.fullCommandName = CommandModel.isNotEmpty(this.getGroup().getName()) ? this.getGroup().getName() + ":" + this.getName() : this.getName();
        }
        return this.fullCommandName;
    }

    public boolean isValid() {
        return CommandModel.isNotEmpty(this.getName());
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getJarVersion() {
        if (this.jarVersion == null) {
            String resourceURL = this.getResourceURL();
            if (resourceURL.contains("!/")) {
                try {
                    LOGGER.debug("Trying to obtain version from [", resourceURL, "] JAR file URL");
                    String jarURI = resourceURL.substring(resourceURL.indexOf("file:/"));
                    jarURI = jarURI.substring(0, jarURI.lastIndexOf("!/"));
                    LOGGER.debug("Reduced URL to [", jarURI, "]");
                    this.jarVersion = VersionUtilities.getManifestVersion(jarURI);
                }
                catch (IOException ioe) {
                    LOGGER.warn(ioe, "Cannot find resource [", resourceURL, "]");
                }
            } else {
                LOGGER.debug("Cannot determine JAR version for URL [", resourceURL, "]");
                this.jarVersion = "unknown";
            }
        }
        return this.jarVersion;
    }

    private String getResourceURL() {
        if (this.resourceURL == null) {
            Class<?> commandClazz = this.command.getClass();
            String className = commandClazz.getName();
            this.resourceURL = commandClazz.getClassLoader().getResource(className.replace(".", "/") + ".class").toString();
        }
        return this.resourceURL;
    }

    public String getJarUri() {
        String resourceURL;
        String jarURI = resourceURL = this.getResourceURL();
        if (resourceURL.contains("!/")) {
            jarURI = resourceURL.substring(resourceURL.indexOf("file:/"));
            jarURI = jarURI.substring(0, jarURI.lastIndexOf("!/"));
        }
        return jarURI;
    }

    public String getCommandVestion() {
        if (this.commandVersion == null) {
            this.commandVersion = this.getJarVersion();
        }
        return this.commandVersion;
    }

    @Override
    public int compareTo(CommandModel that) {
        return this.getFullCommandName().compareTo(that.getFullCommandName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullCommandName == null ? 0 : this.fullCommandName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandModel other = (CommandModel)obj;
        if (this.fullCommandName == null ? other.fullCommandName != null : !this.fullCommandName.equals(other.fullCommandName)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "[" + this.getFullCommandName() + "], " + this.getName();
    }
}

