/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.progress;

import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.progress.ProgressListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ProgressMonitor
implements Runnable {
    private ProgressListener progressListener;
    private ScheduledFuture handler;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private long startTime = System.currentTimeMillis();
    private long lastInvocationTime = System.currentTimeMillis();
    private boolean timedOut = false;

    public ScheduledFuture startProgress(ProgressListener listener, long initialDelay, long delay, long timeout, long progressNotificationTimeout, TimeUnit unit) {
        this.progressListener = listener;
        this.handler = this.scheduler.scheduleWithFixedDelay(this, initialDelay, delay, unit);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ProgressMonitor.this.progressListener.timeoutExpired();
                ProgressMonitor.this.timedOut = true;
                ProgressMonitor.this.handler.cancel(true);
            }
        }, timeout, unit);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ProgressMonitor.this.progressListener.progressNotification();
            }
        }, progressNotificationTimeout, progressNotificationTimeout, unit);
        return this.handler;
    }

    public void waitFor(ScheduledFuture progressHandler) throws CommandException {
        try {
            progressHandler.get();
            this.progressListener.finished();
        }
        catch (CommandException cmdE) {
            this.progressListener.failed();
        }
        catch (CancellationException ce) {
            this.progressListener.finished();
        }
        catch (InterruptedException ie) {
            if (ie.getCause() instanceof CommandException) {
                throw (CommandException)ie.getCause();
            }
            throw new CommandException(ie.getMessage());
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof CommandException) {
                throw (CommandException)ee.getCause();
            }
            throw new CommandException(ee);
        }
    }

    @Override
    public void run() {
        boolean statusCheck;
        try {
            statusCheck = this.progressListener.progressCheck(this.handler);
        }
        catch (CommandException e) {
            this.progressListener.failed();
            throw e;
        }
        this.lastInvocationTime = System.currentTimeMillis();
        if (statusCheck) {
            this.shutdown();
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
        if (this.handler != null) {
            this.handler.cancel(true);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastInvocationTime() {
        return this.lastInvocationTime;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

