/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.spell;

import com.sap.jpaas.infrastructure.console.spell.Distance;
import com.sap.jpaas.infrastructure.console.spell.Utilities;

public class LevensteinEditDistance
implements Distance<String> {
    @Override
    public double distance(String first, String second) {
        int j;
        if (first.isEmpty() || second.isEmpty()) {
            return Math.abs(first.length() - second.length());
        }
        int firstLength = first.length();
        int secondLength = second.length();
        int[][] distanceMatrix = new int[firstLength + 1][secondLength + 1];
        for (int i = 0; i < firstLength; ++i) {
            distanceMatrix[i][0] = i;
        }
        for (j = 0; j < secondLength; ++j) {
            distanceMatrix[0][j] = j;
        }
        for (j = 1; j < secondLength; ++j) {
            for (int i = 1; i < firstLength; ++i) {
                distanceMatrix[i][j] = first.charAt(i - 1) == second.charAt(j - 1) ? distanceMatrix[i - 1][j - 1] : (Integer)Utilities.min((Comparable[])new Integer[]{distanceMatrix[i - 1][j] + 1, distanceMatrix[i][j - 1] + 1, distanceMatrix[i - 1][j - 1] + 1});
            }
        }
        return distanceMatrix[firstLength - 1][secondLength - 1];
    }
}

