/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.spell;

import com.sap.jpaas.infrastructure.console.spell.Distance;
import com.sap.jpaas.infrastructure.console.spell.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuggestEngine {
    private Distance<String> distance;

    public SuggestEngine(Distance<String> distance) {
        this.distance = distance;
    }

    public List<String> didYouMean(String commandName, Collection<String> knownCommands) {
        HashMap<Double, List<String>> distanceToSuggestion = new HashMap<Double, List<String>>();
        for (String knownCommand : knownCommands) {
            this.calculateDistanceAndSuggestions(commandName, distanceToSuggestion, knownCommand, null);
            int index = knownCommand.indexOf(":");
            if (index == -1) continue;
            this.calculateDistanceAndSuggestions(commandName, distanceToSuggestion, knownCommand.substring(index + 1), knownCommand);
        }
        double minDistance = (Double)Utilities.min((Comparable[])distanceToSuggestion.keySet().toArray(new Double[distanceToSuggestion.size()]));
        if (minDistance > (double)(commandName.length() / 2)) {
            return Collections.emptyList();
        }
        return (List)distanceToSuggestion.get(minDistance);
    }

    private void calculateDistanceAndSuggestions(String commandName, Map<Double, List<String>> distanceToSuggestion, String knownCommand, String fullName) {
        double dist = this.distance.distance(commandName, knownCommand);
        List<String> suggestions = distanceToSuggestion.get(dist);
        if (suggestions == null) {
            suggestions = new ArrayList<String>();
        }
        suggestions.add(fullName != null ? fullName : knownCommand);
        distanceToSuggestion.put(dist, suggestions);
    }
}

