/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.update;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.utils.os.OperatingSystemUtils;
import com.sap.core.utils.sdk.status.SDKStatus;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.utils.SdkCallUtils;
import com.sap.core.utils.sdk.utils.SdkFileUtils;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.VersionValidityCheckProvider;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.update.SdkUpgradeUtilities;
import com.sap.jpaas.infrastructure.console.update.SdkUpgrader;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.HostValidator;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;

@Parameters(commandDescription="Provides an automated upgrade of SDK")
public class SdkUpgradeCommand
extends ConsoleCommand {
    public static final String ERROR_COMMAND_SUPPORTS_WINDOWS_AND_LINUX = "Cannot upgrade the SDK. The upgrade command supports Microsoft Windows OS, Linux OS and Mac OS X. You are using a different operating system. Please upgrade manually.";
    private static final String URL_SLASH = "/";
    private static final String DEVELOPER_LICENSE_TXT = "/developer-license.txt";
    private static final String UPGRADING_TO_VERSION = "Upgrading SDK from version {0} to the latest {1} ...";
    private static final String PARAMETER_HOST_DESCRIPTION = "Region for the tools page from which your SDK will be upgraded";
    private static final String TXT = "txt";
    private static final String DEVELOPER_LICENSE = "developer-license";
    private static final String LICENSE = "license";
    private static final String USED_FILES_IN_SDK_DIR = "Files in the SDK directory may be in use. Close any programs that might be using them and try again.";
    private static final String ERROR_PROCESSING_EULA = "Tools update site {0} cannot be reached. Make sure that a tools update site with the specified name exists.";
    private static final String VIEW_EULA_ON = "You can also view the EULA license on {0}.";
    private static final String ERROR_CANNOT_UPGRADE_SDK = "An error occurred during upgrade";
    private static final String Y = "y";
    private static final String MESSAGE_SDK_UNDEFINED = "Cannot determine the SDK version.";
    private static final String YES = "yes";
    private static final String MESSAGE_SDK_STRUCTURE_CHANGE = "SDK upgrade cannot be completed automatically. You need to do it manually.";
    private static final String MESSAGE_UPGRADE_AVAILABLE = "Before upgrading your SDK, review and accept the End User License Agreement (EULA). Do you accept it?<y/n>";
    private static final String MESSAGE_SDK_VERSION_UNDEFINED = "The SDK status could not be determined.";
    private static final String MESSAGE_SDK_UP_TO_DATE = "You have the latest available SDK version. There is no need to upgrade the SDK.";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(SdkUpgradeCommand.class);
    private static Scanner scanner;
    private SDKVersionStatus versionValidityCheckResult;
    @Parameter(names={"-h", "--host"}, description="Region for the tools page from which your SDK will be upgraded", hidden=true, validateWith=HostValidator.class)
    private String host = "hana.ondemand.com";

    @Override
    public void init() throws CommandException {
        scanner = new Scanner(System.in);
        this.host = HostValidator.removeHttpsScheme(this.hostWithoutTrailingSlash().toLowerCase());
        VersionValidityCheckProvider instance = new VersionValidityCheckProvider(this.host);
        instance.nonOptimizedVersionValidityCheck();
        this.versionValidityCheckResult = instance.getVersionValidityCheckResult();
    }

    @Override
    public void run() throws CommandException {
        block6: {
            block4: {
                block5: {
                    if (this.versionValidityCheckResult == null) break block4;
                    SDKStatus status = this.versionValidityCheckResult.getStatus();
                    if (status == null) break block5;
                    LOGGER.info(MessageFormat.format("SDK status is {0}", status.toString()));
                    switch (status) {
                        case LATEST: {
                            DumpHelper.dump(MESSAGE_SDK_UP_TO_DATE);
                            break block6;
                        }
                        case HOTFIX_AVAILABLE: 
                        case NOT_SUPPORTED: 
                        case UPDATE_AVAILABLE: {
                            this.executeUpgrade();
                            break block6;
                        }
                        default: {
                            throw new CommandException(MESSAGE_SDK_VERSION_UNDEFINED);
                        }
                    }
                }
                throw new CommandException(MESSAGE_SDK_VERSION_UNDEFINED);
            }
            throw new CommandException(MESSAGE_SDK_UNDEFINED);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeUpgrade() {
        File userSdkLocation = new File(SdkFileUtils.getCurrentPath()).getParentFile();
        LOGGER.info("Starting to execute SDK upgrade in user's SDK directory: ", userSdkLocation);
        if (!(OperatingSystemUtils.isMac() || OperatingSystemUtils.isUnix() || OperatingSystemUtils.isWindows())) {
            throw new CommandException(ERROR_COMMAND_SUPPORTS_WINDOWS_AND_LINUX);
        }
        if (SdkFileUtils.checkIfDirectoryIsUsed((File)userSdkLocation)) throw new CommandException(USED_FILES_IN_SDK_DIR);
        String updateLink = this.versionValidityCheckResult.getSdk().getDownloadUrl();
        String answer = this.dumpLicense();
        String newSdkName = null;
        if (answer == null || answer != null && (answer.trim().equalsIgnoreCase(Y) || answer.trim().equalsIgnoreCase(YES))) {
            DumpHelper.dumpWithNewLine(MessageFormat.format(UPGRADING_TO_VERSION, VersionUtilities.getReleaseVersion(), this.versionValidityCheckResult.getSdk().getVersion()));
            newSdkName = SdkUpgradeUtilities.downloadAndUnzipSdk(updateLink, this.host);
        }
        if (newSdkName == null) return;
        File newSdk = new File(SdkFileUtils.getTempPath() + File.separator + newSdkName);
        if (!VersionUtilities.areSdkStructuresEqual(userSdkLocation.getAbsolutePath(), newSdk.getAbsolutePath())) throw new CommandException(MESSAGE_SDK_STRUCTURE_CHANGE);
        try {
            SdkUpgrader.upgrade(userSdkLocation, newSdk);
            return;
        }
        catch (IOException ex) {
            throw new CommandException(ERROR_CANNOT_UPGRADE_SDK, ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new CommandException(ERROR_CANNOT_UPGRADE_SDK, ex);
        }
    }

    private String dumpLicense() {
        String answer = null;
        String toolsUpdateSite = MessageFormat.format("https://tools.{0}", this.host);
        try {
            String license = SdkCallUtils.getLicense((String)this.host);
            if (license == null) {
                throw new CommandException(MessageFormat.format(ERROR_PROCESSING_EULA, toolsUpdateSite));
            }
            File userSdkLocation = new File(SdkFileUtils.getCurrentPath()).getParentFile();
            File licenseDir = new File(userSdkLocation, LICENSE);
            if (licenseDir.exists() && licenseDir.isDirectory()) {
                String sdkLicenseFile;
                File licenseFile = this.getLicenseFromSdk(licenseDir);
                String string = sdkLicenseFile = licenseFile != null ? FileUtils.readFileToString((File)licenseFile) : "";
                if (!sdkLicenseFile.equals(license)) {
                    answer = this.printLicenseAndPrompt(license);
                }
            } else {
                answer = this.printLicenseAndPrompt(license);
            }
        }
        catch (IOException ex) {
            throw new CommandException(MessageFormat.format(ERROR_PROCESSING_EULA, toolsUpdateSite), ex);
        }
        return answer;
    }

    private File getLicenseFromSdk(File licenseDirectory) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.startsWith(SdkUpgradeCommand.DEVELOPER_LICENSE) && filename.endsWith(SdkUpgradeCommand.TXT);
            }
        };
        File[] files = licenseDirectory.listFiles(filter);
        return files.length == 1 ? files[0] : null;
    }

    private String printLicenseAndPrompt(String license) {
        String toolsPage = MessageFormat.format("https://tools.{0}", this.host);
        if (license != null) {
            DumpHelper.dump(license);
        }
        DumpHelper.dump(MessageFormat.format(VIEW_EULA_ON, toolsPage + DEVELOPER_LICENSE_TXT));
        DumpHelper.dumpWithNewLine(MESSAGE_UPGRADE_AVAILABLE);
        return scanner.next();
    }

    private String hostWithoutTrailingSlash() {
        return this.host.endsWith(URL_SLASH) ? this.host.substring(0, this.host.length() - 1) : this.host;
    }

    @Override
    public void cleanup() throws CommandException {
    }

    @Override
    public String getName() {
        return "sdk-upgrade";
    }

    @Override
    public String getGroup() {
        return "system";
    }
}

