/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.update;

import com.sap.core.utils.os.OperatingSystemUtils;
import com.sap.core.utils.sdk.status.Version;
import com.sap.core.utils.sdk.utils.SdkFileUtils;
import com.sap.jpaas.infrastructure.console.ConsoleLogger;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SdkUpgradeScriptRunner {
    private static final String EMPTY_STRING = "";
    private static final String QUOTE = "\"";
    private static final String START = "start";
    private static final String WIN_EXEC_PARAM_C = "/C";
    private static final String CMD = "cmd";
    private static final String CHMOD_WRITE_ENABLE = "chmod a+w ";
    private static final String CHMOD_EXECUTE_ENABLE = "chmod a+x ";
    private static final String PID_SEPARATOR = "@";
    private static final String OLD_SDK_BACKUP = "{0}_backup";
    private static final String MESSAGE_UPGRADE_ALMOST_COMPLETED = "Your SDK upgrade will be completed in a few moments ...";
    private static final String MESSAGE_OS_UNSUPPORTED = "Your operating system is not supported by the sdk-upgrade command. Supported are Microsoft Windows OS, Linux OS and Mac OS X. Please upgrade manually.";
    private static final String WIN_SCRIPT_NAME = "sdkWinScript.bat";
    private static final String MAC_SCRIPT_NAME = "sdkUnixScript.sh";
    private static final String DEFAULT_BACKUP_LOCATION = SdkUpgradeScriptRunner.getDefaultBackupFolderName();
    private static final String ERROR_CANNOT_SET_PERMISSIONS = "Error while setting permissions on file {0}";
    private static final ConsoleLogger LOGGER = ConsoleLogger.getLogger(SdkUpgradeScriptRunner.class);
    private final String resourceScript;
    private final String oldSdk;
    private final String newSdk;
    private final String backupSdk;

    private SdkUpgradeScriptRunner(Builder builder) {
        this.oldSdk = builder.oldSdk;
        this.newSdk = builder.newSdk;
        this.backupSdk = builder.backupSdk;
        if (OperatingSystemUtils.isWindows()) {
            this.resourceScript = WIN_SCRIPT_NAME;
        } else if (OperatingSystemUtils.isUnix() || OperatingSystemUtils.isMac()) {
            this.resourceScript = MAC_SCRIPT_NAME;
        } else {
            LOGGER.debug(MessageFormat.format("Operating system is {0}", OperatingSystemUtils.getOS()));
            throw new UnsupportedOperationException(MESSAGE_OS_UNSUPPORTED);
        }
    }

    public void runScript() throws IOException {
        File scriptFile = this.loadScript();
        if (scriptFile != null && scriptFile.isFile()) {
            LOGGER.info("Successfully loaded SDK upgrade script from resources. Proceeding to execution");
            this.executeScript(scriptFile);
        } else {
            LOGGER.info("Cannot not load SDK upgrade script from resources.");
        }
    }

    public String getBackupSdkLocation() {
        return this.backupSdk;
    }

    private File loadScript() throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/" + this.resourceScript);
        File targetFile = new File(SdkFileUtils.getTempPath() + File.separator + this.resourceScript);
        if (!targetFile.isFile()) {
            targetFile.createNewFile();
        }
        if (this.resourceScript.equals(MAC_SCRIPT_NAME)) {
            this.givePermissons(targetFile);
        }
        FileUtils.copyInputStreamToFile((InputStream)in, (File)targetFile);
        return targetFile;
    }

    private void executeScript(File scriptFile) throws IOException {
        String appendQuote = OperatingSystemUtils.isWindows() || OperatingSystemUtils.isMac() ? QUOTE : EMPTY_STRING;
        String javaProcesIdentificator = ManagementFactory.getRuntimeMXBean().getName();
        String javaProcessPID = javaProcesIdentificator.substring(0, javaProcesIdentificator.indexOf(PID_SEPARATOR));
        String oldLocationParam = appendQuote + this.oldSdk + File.separator + appendQuote;
        String newLocationParam = appendQuote + this.newSdk + (!OperatingSystemUtils.isWindows() ? File.separator : EMPTY_STRING) + appendQuote;
        String backupLocationParam = appendQuote + this.backupSdk + (!OperatingSystemUtils.isWindows() ? File.separator : EMPTY_STRING) + appendQuote;
        LOGGER.info("Script file is located in ", scriptFile);
        LOGGER.info("User's SDK location is ", oldLocationParam);
        LOGGER.info("New SDK is downloaded and located in ", newLocationParam);
        LOGGER.info("Backup of user's old SDK is now located in ", backupLocationParam);
        DumpHelper.dumpWithNewLine(MessageFormat.format("Backup of your old SDK is now located in {0}", backupLocationParam));
        if (!SdkFileUtils.checkIfDirectoryIsUsed((File)new File(this.oldSdk))) {
            LOGGER.debug(scriptFile, " can execute ? ", scriptFile.canExecute());
            LOGGER.debug(scriptFile, " can write ? ", scriptFile.canWrite());
            LOGGER.debug(scriptFile, " can read ? ", scriptFile.canRead());
            DumpHelper.dumpWithNewLine(MESSAGE_UPGRADE_ALMOST_COMPLETED);
            if (OperatingSystemUtils.isWindows()) {
                this.startUpgradeProcess(CMD, WIN_EXEC_PARAM_C, START, scriptFile.getAbsolutePath(), javaProcessPID, oldLocationParam, newLocationParam, backupLocationParam);
            } else if (OperatingSystemUtils.isMac() || OperatingSystemUtils.isUnix()) {
                Process startUpgradeProcess = this.startUpgradeProcess(scriptFile.getAbsolutePath(), javaProcessPID, oldLocationParam, newLocationParam, backupLocationParam);
                IOUtils.copy((InputStream)startUpgradeProcess.getInputStream(), (OutputStream)System.out);
            } else {
                throw new CommandException("Cannot upgrade the SDK. The upgrade command supports Microsoft Windows OS, Linux OS and Mac OS X. You are using a different operating system. Please upgrade manually.");
            }
        }
    }

    private Process startUpgradeProcess(String ... args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(args);
        LOGGER.info("Executing ", pb.command());
        return pb.start();
    }

    private void givePermissons(File scriptFile) throws IOException {
        String scriptFilePath = scriptFile.getAbsolutePath();
        LOGGER.info(MessageFormat.format("Executing chmod +x and chmod +w on {0}", scriptFilePath));
        Process execPermissions = Runtime.getRuntime().exec(CHMOD_EXECUTE_ENABLE + scriptFilePath);
        Process writePermissons = Runtime.getRuntime().exec(CHMOD_WRITE_ENABLE + scriptFilePath);
        try {
            execPermissions.waitFor();
            LOGGER.info("Exit code for chmod +x on ", scriptFilePath, " was ", execPermissions.exitValue());
            writePermissons.waitFor();
            LOGGER.info("Exit code for chmod +w on ", scriptFilePath, " was ", writePermissons.exitValue());
        }
        catch (InterruptedException e) {
            throw new CommandException(MessageFormat.format(ERROR_CANNOT_SET_PERMISSIONS, scriptFile));
        }
    }

    private static String getDefaultBackupFolderName() {
        Version sdkVersion = new Version(VersionUtilities.getReleaseVersion());
        String param = VersionUtilities.getRuntime() + sdkVersion.getMajor();
        return SdkFileUtils.getTempPath() + File.separator + MessageFormat.format(OLD_SDK_BACKUP, param);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_BACKUP_LOCATION;
    }

    public static class Builder {
        private final String oldSdk;
        private final String newSdk;
        private String backupSdk = SdkUpgradeScriptRunner.access$000();

        public Builder(String oldSdk, String newSdk) {
            this.oldSdk = oldSdk;
            this.newSdk = newSdk;
        }

        public Builder sdkBackupLocation(String backupLocation) {
            this.backupSdk = backupLocation;
            return this;
        }

        public SdkUpgradeScriptRunner build() {
            return new SdkUpgradeScriptRunner(this);
        }
    }
}

