/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.update;

import com.sap.core.utils.sdk.utils.SdkCallUtils;
import com.sap.core.utils.sdk.utils.SdkFileUtils;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class SdkUpgradeUtilities {
    private static final String ERROR_OCCURRED_WHILE_DOWNLOADING_THE_NEW_SDK = "An error occurred while downloading the new SDK";
    private static final String AN_ERROR_OCCURED_WHILE_UNZIPPING_THE_SDK = "An error occured while unzipping the SDK. Please start over ";
    private static final String MESSAGE_DOWNLOADING_SDK_PACKAGE = "Downloading SDK package ...";
    private static final String MESSAGE_UNZIPPING_SDK_PACKAGE = "Unzipping SDK package ...";
    private static final String TOOLS_URL = "https://tools.{0}/{1}";

    public static String downloadAndUnzipSdk(String downloadLink, String host) {
        String url = MessageFormat.format(TOOLS_URL, host, downloadLink);
        String destinationFolder = SdkFileUtils.getTempPath();
        String sdkZipFileName = url.substring(url.lastIndexOf("/") + 1);
        String folderToUnzipIn = sdkZipFileName.substring(0, sdkZipFileName.lastIndexOf("."));
        File fullPathZipFile = new File(destinationFolder, sdkZipFileName);
        String destionationFile = destinationFolder + File.separatorChar + sdkZipFileName;
        DumpHelper.dumpWithNewLine(MESSAGE_DOWNLOADING_SDK_PACKAGE);
        boolean result = false;
        try {
            result = SdkCallUtils.downloadSdkZipFile((String)url, (String)host, (String)destionationFile);
        }
        catch (IOException ex) {
            throw new CommandException(ERROR_OCCURRED_WHILE_DOWNLOADING_THE_NEW_SDK, ex);
        }
        if (!result) {
            throw new CommandException(ERROR_OCCURRED_WHILE_DOWNLOADING_THE_NEW_SDK);
        }
        DumpHelper.dump(MESSAGE_UNZIPPING_SDK_PACKAGE);
        try {
            String file = fullPathZipFile.getParentFile().getAbsolutePath() + File.separator + folderToUnzipIn + File.separator;
            SdkFileUtils.extractZipFile((String)fullPathZipFile.getAbsolutePath(), (String)file);
        }
        catch (IOException ex) {
            throw new CommandException(AN_ERROR_OCCURED_WHILE_UNZIPPING_THE_SDK, ex);
        }
        return folderToUnzipIn;
    }
}

