/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.update;

import com.sap.jpaas.infrastructure.console.update.SdkUpgradeScriptRunner;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class SdkUpgrader {
    private static final String MESSAGE_SERVER_DIRECTORY_IS_PRESENT = "Your SDK server directory will be kept but you need to reinstall it using the install-local command so that it matches the new SDK version.";
    private static final String SERVER = "server";

    public static void upgrade(File oldSdk, File newSdk) throws IOException {
        SdkUpgradeScriptRunner scriptRunner = new SdkUpgradeScriptRunner.Builder(oldSdk.getAbsolutePath(), newSdk.getAbsolutePath()).build();
        if (newSdk.exists() && !newSdk.isDirectory()) {
            newSdk.delete();
            newSdk.mkdir();
        }
        SdkUpgrader.backupOldSdk(oldSdk, new File(scriptRunner.getBackupSdkLocation()));
        SdkUpgrader.checkForServerDirectory(oldSdk);
        scriptRunner.runScript();
    }

    private static void backupOldSdk(File oldSdk, File backupDir) throws IOException {
        if (backupDir.isDirectory()) {
            FileUtils.deleteDirectory((File)backupDir);
        }
        FileUtils.copyDirectory((File)oldSdk, (File)backupDir);
    }

    private static void checkForServerDirectory(File oldSdk) {
        for (String name : oldSdk.list()) {
            File file;
            if (!name.equals(SERVER) || !(file = new File(oldSdk + File.separator + SERVER)).isDirectory()) continue;
            DumpHelper.dumpWithNewLine(MESSAGE_SERVER_DIRECTORY_IS_PRESENT);
            break;
        }
    }
}

