/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.util;

import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class DumpHelper {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void dumpKeyValue(String key, Object value) {
        DumpHelper.dump(key + ": " + value.toString());
    }

    public static void dumpWithNewLine(String message) {
        System.out.println();
        DumpHelper.dump(message);
    }

    public static void dumpErrorMessage(String msg) {
        DumpHelper.dumpMessage(msg, "(!) ERROR");
    }

    public static void dumpWarningMessage(String msg) {
        DumpHelper.dumpMessage(msg, "Warning");
    }

    public static void dumpMessage(String msg, String severity) {
        String message = LINE_SEPARATOR + severity + ": " + msg + LINE_SEPARATOR;
        if (severity.equals("(!) ERROR")) {
            System.err.println(message);
        } else {
            DumpHelper.dump(message);
        }
    }

    public static void dump(String message) {
        System.out.println(message);
    }

    public static void dumpOperationList(String title, Object ... list) {
        DumpHelper.dumpOperationList(null, title, false, list);
    }

    public static void dumpOperationList(String user, String title, Object ... list) {
        DumpHelper.dumpOperationList(user, title, true, list);
    }

    public static void dumpOperationList(String user, String title, boolean dumpSDKVersion, Object ... list) {
        Object[] objectList;
        String sdkVersion = VersionUtilities.getReleaseVersion();
        if (!sdkVersion.equals("unknown")) {
            objectList = new Object[list.length + (user != null ? 2 : 0) + (dumpSDKVersion ? 2 : 0)];
            System.arraycopy(list, 0, objectList, 0, list.length);
            if (dumpSDKVersion) {
                objectList[list.length] = "SDK version";
                objectList[list.length + 1] = sdkVersion;
            }
            if (user != null) {
                objectList[list.length + 2] = "user";
                objectList[list.length + 3] = user;
            }
        } else {
            objectList = new Object[list.length + (user != null ? 2 : 0)];
            System.arraycopy(list, 0, objectList, 0, list.length);
            if (user != null) {
                objectList[list.length] = "user";
                objectList[list.length + 1] = user;
            }
        }
        if (objectList.length % 2 != 0) {
            throw new IllegalArgumentException("Missing values in list [" + Arrays.toString(list) + "]");
        }
        int max = 0;
        for (int i = 0; i < objectList.length; i += 2) {
            int length = objectList[i].toString().length();
            if (length <= max) continue;
            max = length;
        }
        DumpHelper.dumpWithNewLine(title);
        String formatString = "   %-" + max + "s: %s";
        String formatStringParams = "%-" + (max + 3) + "s  %s";
        for (int i = 0; i < objectList.length; i += 2) {
            Object valueAsObj = objectList[i + 1];
            if (valueAsObj == null) continue;
            if (valueAsObj instanceof Collection) {
                Collection valueAsCollection = (Collection)valueAsObj;
                if (valueAsCollection.isEmpty()) continue;
                Iterator iterator = valueAsCollection.iterator();
                DumpHelper.dump(String.format(formatString, objectList[i], iterator.next()));
                while (iterator.hasNext()) {
                    DumpHelper.dump(String.format(formatStringParams, "", iterator.next()));
                }
                continue;
            }
            String valueAsStr = objectList[i + 1].toString().trim();
            if (valueAsStr.isEmpty()) continue;
            DumpHelper.dump(String.format(formatString, objectList[i], valueAsStr));
        }
        System.out.println();
    }
}

