/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.util;

import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MessageUtils {
    public static final String SEVERITY_ERROR = "(!) ERROR";
    public static final String SEVERITY_WARNING = "Warning";
    public static final String SEVERITY_SEPARATOR = ": ";
    private static final String PARAMETER = "Parameter";
    private static final String WITH_VALUE = "with value";
    private static final String IS_NOT_VALID = "is not valid.";
    private static final String SINGLE_QUATATION_MARK = "'";
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private static final String EMPTY = " ";

    public static String getErrorMessage(CommandException ce) {
        StringBuilder errorMessage = new StringBuilder();
        if (ce != null) {
            boolean duplicateMessage;
            String excMsg;
            String causeMessage;
            errorMessage.append(SEVERITY_ERROR);
            Throwable cause = ce.getCause();
            String string = causeMessage = cause != null ? cause.getMessage() : null;
            if (cause instanceof HostValidationException) {
                causeMessage = ((HostValidationException)cause).getValidationErrorMessage();
            }
            if ((excMsg = ce.getMessage()) != null && excMsg.length() > 1) {
                errorMessage.append(SEVERITY_SEPARATOR).append(excMsg);
            }
            boolean bl = duplicateMessage = excMsg != null && causeMessage != null && excMsg.contains(causeMessage);
            if (causeMessage != null && !duplicateMessage) {
                errorMessage.append("; ").append(causeMessage);
            }
        }
        return errorMessage.toString();
    }

    public static String getParameterValidationErrorMessage(String[] commandLineArguments, List<String> parameterNames, ParameterValidationException pve) {
        StringBuilder errorMessage = new StringBuilder();
        StringBuilder parameter = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>(parameterNames);
        List<String> commandLineArgumentsList = Arrays.asList(commandLineArguments);
        for (String next : names) {
            if (!commandLineArgumentsList.contains(next)) continue;
            names.remove(next);
            parameter.append(next);
            if (names.size() <= 0) break;
            parameter.append(EMPTY);
            parameter.append(LEFT_BRACKET);
            String namesString = ((Object)names).toString();
            parameter.append(namesString.substring(1, namesString.length() - 1));
            parameter.append(RIGHT_BRACKET);
            break;
        }
        errorMessage.append(PARAMETER);
        errorMessage.append(EMPTY);
        errorMessage.append(parameter.toString());
        errorMessage.append(EMPTY);
        errorMessage.append(WITH_VALUE);
        errorMessage.append(EMPTY);
        errorMessage.append(SINGLE_QUATATION_MARK);
        errorMessage.append(pve.getValue());
        errorMessage.append(SINGLE_QUATATION_MARK);
        errorMessage.append(EMPTY);
        errorMessage.append(IS_NOT_VALID);
        if (pve.getMessage() != null && !pve.getMessage().isEmpty()) {
            errorMessage.append(EMPTY);
            errorMessage.append(pve.getMessage());
        }
        return errorMessage.toString();
    }
}

