/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.core.utils.infrastructure.validation.SACNameValidator;
import com.sap.core.utils.infrastructure.validation.Severity;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.HashSet;
import java.util.Set;

public class ApplicationValidator
implements IParameterValidator {
    private static Set<String> dumpedWarnings = new HashSet<String>();

    public void validate(String name, String applicationName) throws ParameterException {
        ValidationStatus validationStatus = SACNameValidator.validateApplication((String)applicationName);
        String validationStatusMessage = validationStatus.getMessage();
        if (validationStatus.isError()) {
            throw new ParameterValidationException(name, applicationName, validationStatusMessage);
        }
        if (validationStatus.getSeverity().equals((Object)Severity.WARNING) && dumpedWarnings.add(validationStatusMessage)) {
            DumpHelper.dumpWarningMessage(validationStatusMessage);
        }
    }
}

