/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.validator.routines.UrlValidator;

public class HostValidator
implements IParameterValidator {
    public static final String HTTP_SCHEME_PREFIX = "http://";
    public static final String HTTPS_SCHEME_PREFIX = "https://";
    private static final UrlValidator VALIDATOR = new UrlValidator(new String[]{"https"});
    public static final String SYSTEM_PROPERTY_CSV_DOMAINS_IGNORED_FOR_URL_VALIDATION = "csv_domains_ignored_for_url_validation";
    public static final String DEFAULT_SUFFIX_VALUE = ".corp";

    public void validate(String name, String value) throws ParameterException {
        if (value == null || value.trim().isEmpty()) {
            throw new ParameterValidationException(name, value, "No value was specified.");
        }
        if (!VALIDATOR.isValid(value = HostValidator.addHttpsScheme(value.toLowerCase()))) {
            try {
                String domainSuffix = this.getDomainSuffix(value);
                if (HostValidator.getIgnoreValidationDomainsSet().contains(domainSuffix)) {
                    return;
                }
            }
            catch (MalformedURLException e) {
                throw new ParameterValidationException(name, value, "Invalid URL.");
            }
            throw new ParameterValidationException(name, value, "Invalid URL.");
        }
    }

    private String getDomainSuffix(String value) throws MalformedURLException {
        URL url = new URL(value);
        String host = url.getHost();
        if (host.indexOf(".") > 0) {
            return host.substring(host.lastIndexOf("."));
        }
        throw new MalformedURLException("No suffix");
    }

    public static String addHttpsScheme(String value) {
        if (!value.startsWith(HTTPS_SCHEME_PREFIX) && !value.startsWith(HTTP_SCHEME_PREFIX)) {
            value = HTTPS_SCHEME_PREFIX + value;
        }
        return value;
    }

    public static String removeHttpsScheme(String value) {
        return value.replaceFirst(HTTPS_SCHEME_PREFIX, "").replaceFirst(HTTP_SCHEME_PREFIX, "");
    }

    private static Set<String> getIgnoreValidationDomainsSet() {
        String ignoreValiationDomainsToParse = System.getProperty(SYSTEM_PROPERTY_CSV_DOMAINS_IGNORED_FOR_URL_VALIDATION, DEFAULT_SUFFIX_VALUE);
        String[] ignoreValidationDomains = ignoreValiationDomainsToParse.split(",");
        return new HashSet<String>(Arrays.asList(ignoreValidationDomains));
    }
}

