/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import java.util.regex.Pattern;

public class SACValidator
implements IParameterValidator {
    private static final Pattern PATTERN_ALPHANUMERIC_LOWERCASE = Pattern.compile("^[a-z][a-z0-9]{0,29}$");

    public void validate(String name, String value) throws ParameterException {
        if (value == null || !PATTERN_ALPHANUMERIC_LOWERCASE.matcher(value).matches()) {
            throw new ParameterValidationException(name, value, "It must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters.");
        }
    }
}

