/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.jpaas.infrastructure.console.exception.ParameterValidationException;
import java.util.Arrays;

public class StructuredOutputParameterValidator
implements IParameterValidator {
    public static final String JSON = "json";
    public static final String[] ALLOWED_VALUES = new String[]{"json"};

    public void validate(String name, String value) throws ParameterException {
        if (value == null || value.trim().isEmpty()) {
            throw new ParameterValidationException(name, value, "No value was specified.");
        }
        boolean isValid = false;
        for (String allowedValue : ALLOWED_VALUES) {
            if (!allowedValue.equals(value)) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            String message = null;
            message = ALLOWED_VALUES.length > 1 ? "Supported values are \"%s\"." : "Supported value is \"%s\".";
            throw new ParameterValidationException(name, value, String.format(message, Arrays.toString(ALLOWED_VALUES).replace("[", "").replace("]", "")));
        }
    }
}

