/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.version;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.utils.sdk.status.RuntimeType;
import com.sap.core.utils.sdk.status.SDKStatus;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.status.SDKVersionStatusUtils;
import com.sap.core.utils.sdk.status.SdkRuntimeUndefinedException;
import com.sap.jpaas.infrastructure.console.CommandManager;
import com.sap.jpaas.infrastructure.console.ConsoleClient;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SDKException;
import com.sap.jpaas.infrastructure.console.model.CommandModel;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.HostValidator;
import com.sap.jpaas.infrastructure.console.version.VersionUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.ServiceUnavailableException;

@Parameters(commandDescription="Shows SDK version, runtime, JAR files, and command versions and checks for SDK updates")
public class VersionCommand
extends ConsoleCommand<Map<String, String>> {
    public static final String SAP_NET_WEAVER_NEO = "SAP Cloud Platform";
    protected static final String RELEASE_VERSION = "release.version";
    private static final String SDK_VERSION_OUTPUT = "SDK version";
    private static final String RUNTIME_OUTPUT = "Runtime";
    private static final String MSG_DOWNLOAD_NEW_SDK = "SDK is not supported. Download a new SDK.";
    private static final String MSG_SDK_STATUS_UNDEFINED = "The SDK status could not be determined.";
    private static final String EMPTY_MESSAGE = "";
    private static final String SDK_STATUS_VERSION_FORMAT = "%s    : %s %s";
    private static final String SDK_VERSION_FORMAT = "%s    : %s";
    private static final String SDK_MESSAGE_FORMAT = "                 %s";
    private static final String SDK_MESSAGE_WITH_AVAILABLE_VERSION_FORMAT = "                 %s %s";
    private static final String RUNTIME_FORMAT = "%s        : %s";
    private static final String SDK_VERSION_OUTPUT_LATEST_LINE1 = "- latest";
    private static final String SDK_VERSION_OUTPUT_HOT_FIX_LINE1 = "- hot-fix available";
    private static final String SDK_VERSION_OUTPUT_HOT_FIX_LINE2 = "Upgrade to version";
    private static final String SDK_VERSION_OUTPUT_UPDATE_LINE1 = "- not latest";
    private static final String SDK_VERSION_OUTPUT_UPDATE_LINE2 = "Consider upgrading to the latest version";
    private static final String SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE1 = "- deprecated";
    private static final String SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE2 = "This version may not work";
    private static final String SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE3 = "Upgrade to the latest version";
    private static final String CANNOT_RETURN_VERSION_INFORMATION = "Cannot return version information. The folder structure of the SDK seems inconsistent. Install a fresh SDK copy.";
    private static final String SDKVERSION = "SDKVersion";
    private static final String RUNTIME = "Runtime";
    private static final String UPDATED_VERSION = "updatedVersion";
    private static final String DOWNLOAD_URL = "downloadUrl";
    private static final String LATEST_VERSION = "latestVersion";
    private static final String VALIDITY_STATUS = "validityStatus";
    private static final String HTTPS_TOOLS = "https://tools.";
    @Parameter(names={"-c", "--commands"}, description="Lists command versions")
    boolean showCommands;
    @Parameter(names={"-j", "-jars", "--jars"}, description="Lists JAR files")
    boolean showJARs;
    @Parameter(names={"-u", "--updates"}, description="Checks for updates and hot-fixes and whether the SDK version is still supported; shows the latest available version")
    boolean updates;
    @Parameter(names={"-h", "--host"}, description="Region host on which you execute the command", hidden=true)
    String host = "hana.ondemand.com";

    @Override
    public void init() throws CommandException {
    }

    @Override
    public void run() throws CommandException {
        Object structuredOutput = this.runForStructuredOutput();
        String sdkStatus = (String)structuredOutput.get(VALIDITY_STATUS);
        if (sdkStatus != null) {
            switch (SDKStatus.valueOf((String)sdkStatus)) {
                case LATEST: {
                    this.dumpLatestSDK(SDK_VERSION_OUTPUT, "Runtime", (String)structuredOutput.get(SDKVERSION), (String)structuredOutput.get("Runtime"), SDK_VERSION_OUTPUT_LATEST_LINE1);
                    break;
                }
                case HOTFIX_AVAILABLE: {
                    this.dumpHotFixUpdateAvailableSDK(SDK_VERSION_OUTPUT, "Runtime", (String)structuredOutput.get(SDKVERSION), (String)structuredOutput.get("Runtime"), (String)structuredOutput.get(UPDATED_VERSION), SDK_VERSION_OUTPUT_HOT_FIX_LINE1, SDK_VERSION_OUTPUT_HOT_FIX_LINE2);
                    break;
                }
                case UPDATE_AVAILABLE: {
                    this.dumpHotFixUpdateAvailableSDK(SDK_VERSION_OUTPUT, "Runtime", (String)structuredOutput.get(SDKVERSION), (String)structuredOutput.get("Runtime"), (String)structuredOutput.get(LATEST_VERSION), SDK_VERSION_OUTPUT_UPDATE_LINE1, SDK_VERSION_OUTPUT_UPDATE_LINE2);
                    break;
                }
                case NOT_SUPPORTED: {
                    this.dumpNotSupportedSDK(SDK_VERSION_OUTPUT, "Runtime", (String)structuredOutput.get(SDKVERSION), (String)structuredOutput.get("Runtime"), (String)structuredOutput.get(LATEST_VERSION), SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE1, SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE2, SDK_VERSION_OUTPUT_NOT_SUPPORTED_LINE3);
                    break;
                }
            }
        } else {
            this.dumpSDK(SDK_VERSION_OUTPUT, "Runtime", (String)structuredOutput.get(SDKVERSION), (String)structuredOutput.get("Runtime"));
        }
        if (this.showCommands || this.showJARs) {
            this.dumpCommandVersions(this.showCommands, this.showJARs);
        }
        DumpHelper.dump(EMPTY_MESSAGE);
    }

    @Override
    public Map<String, String> runForStructuredOutput() throws CommandException {
        String neoSDKVersion = this.formatString(VersionUtilities.getReleaseVersion());
        String neoRuntime = this.formatString(VersionUtilities.getRuntime());
        Map<String, String> structuredOutput = null;
        if (this.updates) {
            String formatUnknown = this.formatString("unknown");
            if (neoSDKVersion.equals(formatUnknown) || neoRuntime.equals(formatUnknown)) {
                throw new SDKException(CANNOT_RETURN_VERSION_INFORMATION);
            }
            RuntimeType runtimeType = VersionUtilities.parseRuntime(neoRuntime, neoSDKVersion);
            if (runtimeType == null) {
                throw new SDKException(CANNOT_RETURN_VERSION_INFORMATION);
            }
            this.host = HostValidator.removeHttpsScheme(this.host);
            SDKVersionStatus status = null;
            try {
                status = SDKVersionStatusUtils.determineStatus((String)neoSDKVersion, (String)this.host, (RuntimeType)runtimeType);
            }
            catch (IOException ex) {
                throw new CommandException(ex.getMessage(), ex);
            }
            catch (ServiceUnavailableException ex) {
                throw new CommandException(ex.getMessage(), ex);
            }
            catch (SdkRuntimeUndefinedException ex) {
                throw new CommandException(MSG_DOWNLOAD_NEW_SDK, ex);
            }
            SDKStatus sdkStatus = status.getStatus();
            if (sdkStatus.equals((Object)SDKStatus.UNDEFINED)) {
                throw new CommandException(MSG_SDK_STATUS_UNDEFINED);
            }
            structuredOutput = this.fillStructuredOutput(neoSDKVersion, neoRuntime, status, this.host);
        } else {
            structuredOutput = new HashMap<String, String>();
            structuredOutput.put(SDKVERSION, neoSDKVersion);
            structuredOutput.put("Runtime", neoRuntime);
        }
        return structuredOutput;
    }

    private void dumpCommandVersions(boolean showCommands, boolean showJARs) {
        CommandManager manager = ConsoleClient.getManager();
        Map<String, String> versions = manager.getJarVersions();
        Map<String, Set<String>> commands = manager.getCommandVersions();
        DumpHelper.dump(EMPTY_MESSAGE);
        DumpHelper.dump("Command versions:");
        int maxKeyLength = 0;
        Collection<String> values = showJARs ? versions.keySet() : CommandModel.getVisibleCommandNames(manager.getCommandModels());
        for (String key : values) {
            if (maxKeyLength >= key.length()) continue;
            maxKeyLength = key.length();
        }
        String formatString = "   %-" + maxKeyLength + "s   %s";
        for (String location : versions.keySet()) {
            String version = versions.get(location);
            if (showJARs) {
                DumpHelper.dump(String.format(formatString, location, version));
            }
            if (!showCommands) continue;
            for (String command : commands.get(location)) {
                if (showJARs) {
                    DumpHelper.dump("      " + command);
                    continue;
                }
                DumpHelper.dump(String.format(formatString, command, version));
            }
        }
    }

    @Override
    public void cleanup() throws CommandException {
    }

    @Override
    public String getName() {
        return "version";
    }

    @Override
    public String getGroup() {
        return "system";
    }

    private String formatString(String string) {
        if ("unknown".equals(string)) {
            return "<" + string + ">";
        }
        return string;
    }

    private Map<String, String> fillStructuredOutput(String neoSDKVersion, String runtime, SDKVersionStatus sdkVersionStatus, String landscape) {
        HashMap<String, String> structuredOutput = new HashMap<String, String>();
        SDKStatus sdkStatus = sdkVersionStatus.getStatus();
        String sdkVersion = sdkVersionStatus.getSdk().getVersion();
        String sdkUrl = HTTPS_TOOLS + landscape + "/" + sdkVersionStatus.getSdk().getDownloadUrl();
        structuredOutput.put(SDKVERSION, neoSDKVersion);
        structuredOutput.put("Runtime", runtime);
        structuredOutput.put(VALIDITY_STATUS, sdkStatus.name());
        switch (SDKStatus.valueOf((String)sdkStatus.name())) {
            case LATEST: {
                break;
            }
            case HOTFIX_AVAILABLE: {
                structuredOutput.put(UPDATED_VERSION, sdkVersion);
                structuredOutput.put(DOWNLOAD_URL, sdkUrl);
                break;
            }
            case UPDATE_AVAILABLE: 
            case NOT_SUPPORTED: {
                structuredOutput.put(LATEST_VERSION, sdkVersion);
                structuredOutput.put(DOWNLOAD_URL, sdkUrl);
                break;
            }
        }
        return structuredOutput;
    }

    private void dumpLatestSDK(String sdkText, String runtimeText, String sdkVersion, String runtime, String line1Text) {
        DumpHelper.dump(String.format(SDK_STATUS_VERSION_FORMAT, sdkText, sdkVersion, line1Text));
        DumpHelper.dump(String.format(RUNTIME_FORMAT, runtimeText, runtime));
    }

    private void dumpHotFixUpdateAvailableSDK(String sdkText, String runtimeText, String sdkVersion, String runtime, String sdkAvailable, String line1Text, String line2Text) {
        DumpHelper.dump(String.format(SDK_STATUS_VERSION_FORMAT, sdkText, sdkVersion, line1Text));
        DumpHelper.dump(String.format(SDK_MESSAGE_WITH_AVAILABLE_VERSION_FORMAT, line2Text, sdkAvailable));
        DumpHelper.dump(String.format(RUNTIME_FORMAT, runtimeText, runtime));
    }

    private void dumpNotSupportedSDK(String sdkText, String runtimeText, String sdkVersion, String runtime, String sdkAvailable, String line1Text, String line2Text, String line3Text) {
        DumpHelper.dump(String.format(SDK_STATUS_VERSION_FORMAT, sdkText, sdkVersion, line1Text));
        DumpHelper.dump(String.format(SDK_MESSAGE_FORMAT, line2Text));
        DumpHelper.dump(String.format(SDK_MESSAGE_WITH_AVAILABLE_VERSION_FORMAT, line3Text, sdkAvailable));
        DumpHelper.dump(String.format(RUNTIME_FORMAT, runtimeText, runtime));
    }

    private void dumpSDK(String sdkText, String runtimeText, String sdkVersion, String runtime) {
        DumpHelper.dump(String.format(SDK_VERSION_FORMAT, sdkText, sdkVersion));
        DumpHelper.dump(String.format(RUNTIME_FORMAT, runtimeText, runtime));
    }
}

