/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console.version;

import com.sap.core.utils.sdk.status.RuntimeType;
import com.sap.core.utils.sdk.status.Version;
import com.sap.jpaas.infrastructure.console.PropertyFileProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class VersionUtilities {
    public static final String BASE_LOCATION_PROP = "neo.base.location";
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String SDK_VERSION_FILE = "sdk.version";
    public static final String RUNTIME_ID_NAME = "runtime.id";
    public static final String RUNTIME_VERSION = "runtime.version";
    public static final String STRUCTURE_VERSION = "structure.version";
    public static final Logger LOG = Logger.getLogger(VersionUtilities.class);
    static Properties sdkVersionProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readSDKVersionProperties() {
        File versionFile = new File(System.getProperty(BASE_LOCATION_PROP), ".." + File.separatorChar + SDK_VERSION_FILE);
        sdkVersionProperties = new Properties();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(versionFile));
            sdkVersionProperties.load(new BufferedInputStream(is));
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("There is no config file: " + versionFile.toString()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getManifestVersion(String jarFileURI) throws IOException {
        JarInputStream jarStream;
        BufferedInputStream fileStream;
        block5: {
            block4: {
                String string;
                fileStream = null;
                jarStream = null;
                try {
                    fileStream = new BufferedInputStream(new FileInputStream(new File(URI.create(jarFileURI))));
                    jarStream = new JarInputStream(fileStream);
                    Manifest manifest = jarStream.getManifest();
                    Attributes mainAttributes = manifest.getMainAttributes();
                    String version = mainAttributes.getValue(IMPLEMENTATION_VERSION);
                    if (version == null) break block4;
                    string = version;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jarStream);
                    IOUtils.closeQuietly(fileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)jarStream);
                IOUtils.closeQuietly((InputStream)fileStream);
                return string;
            }
            if (!jarFileURI.contains("-") || jarFileURI.length() <= 4) break block5;
            String string = jarFileURI.substring(jarFileURI.lastIndexOf("-") + 1, jarFileURI.length() - 4);
            IOUtils.closeQuietly((InputStream)jarStream);
            IOUtils.closeQuietly((InputStream)fileStream);
            return string;
        }
        String string = UNKNOWN_VERSION;
        IOUtils.closeQuietly((InputStream)jarStream);
        IOUtils.closeQuietly((InputStream)fileStream);
        return string;
    }

    public static String getSDKVersion() {
        return sdkVersionProperties.getProperty("release.version", UNKNOWN_VERSION);
    }

    public static String getRuntime() {
        return sdkVersionProperties.getProperty(RUNTIME_ID_NAME, UNKNOWN_VERSION);
    }

    public static String getRuntimeVersion() {
        String version = sdkVersionProperties.getProperty(RUNTIME_VERSION, UNKNOWN_VERSION);
        if (version.equals(UNKNOWN_VERSION)) {
            version = VersionUtilities.getReleaseVersion();
        }
        return version;
    }

    public static String getReleaseVersion() {
        String version = sdkVersionProperties.getProperty("release.version", UNKNOWN_VERSION);
        return version;
    }

    public static RuntimeType parseRuntime(String runtimeId, String releaseVersion) {
        RuntimeType neoRuntime = null;
        try {
            Version version = new Version(releaseVersion);
            neoRuntime = RuntimeType.getRuntimeType((String)runtimeId, (int)version.getMajor());
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("The runtime type [" + runtimeId + "] or version [" + releaseVersion + "] are not correct."), (Throwable)e);
        }
        return neoRuntime;
    }

    public static boolean areSdkStructuresEqual(String oldSdk, String newSdk) {
        boolean result = false;
        File firstSdkVersion = new File(oldSdk, SDK_VERSION_FILE);
        File secondSdkVersion = new File(newSdk, SDK_VERSION_FILE);
        if (firstSdkVersion.isFile() && secondSdkVersion.isFile()) {
            result = VersionUtilities.determineStructureVersion(secondSdkVersion).equals(VersionUtilities.determineStructureVersion(firstSdkVersion));
        }
        return result;
    }

    private static String determineStructureVersion(File sdkFile) {
        PropertyFileProvider newSdkPropertyProvider = new PropertyFileProvider(sdkFile.getAbsolutePath());
        return newSdkPropertyProvider.getDefaultValueFor(STRUCTURE_VERSION);
    }

    static {
        VersionUtilities.readSDKVersionProperties();
    }
}

