/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.service.securestore.password.local;

import com.sap.jpaas.service.securestore.password.PasswordStorage;
import com.sap.jpaas.service.securestore.password.PasswordStorageException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PasswordStorageImpl
implements PasswordStorage {
    private static final Logger logger = Logger.getLogger(PasswordStorageImpl.class);
    private static final String ALIAS_PASS_FILE = "aliasPasswordFile";
    private File aliasPasswordFile = new File("aliasPasswordFile");
    private Properties aliasPasswordProperties = null;

    public void setPassword(String alias, char[] password) throws PasswordStorageException, IllegalArgumentException {
        if (password == null || alias == null) {
            throw new IllegalArgumentException("Illegal arguments passed to setPassword(String alias, char[] password) method. Alias and password should not be null.");
        }
        if (password.length < 6 || password.length > 255) {
            throw new IllegalArgumentException("Password should not be smaller than 6 characters and no bigger than 255 characters.");
        }
        this.validateAlias(alias);
        try {
            this.addPasswordForAlias(alias, password);
        }
        catch (IOException e) {
            logger.error((Object)"Error occurred while trying to store password in the local password file.", (Throwable)e);
            throw new PasswordStorageException("Error occurred while trying to store password in the local password file [ aliasPasswordFile ].", (Throwable)e);
        }
    }

    public char[] getPassword(String alias) throws PasswordStorageException, IllegalArgumentException {
        if (alias == null) {
            throw new IllegalArgumentException("Illegal argument passed to the method. Alias should not be null.");
        }
        this.validateAlias(alias);
        try {
            return this.readPasswordFile(alias);
        }
        catch (IOException e) {
            logger.error((Object)"Error occurred while trying to read local file to load the password.", (Throwable)e);
            throw new PasswordStorageException("Error occurred while trying get password with alias [ " + alias + " ].", (Throwable)e);
        }
    }

    public void deletePassword(String alias) throws PasswordStorageException {
        if (alias == null) {
            throw new IllegalArgumentException("Illegal argument passed to the method. Alias should not be null.");
        }
        this.validateAlias(alias);
        try {
            this.deletePasswordForAlias(alias);
        }
        catch (IOException e) {
            logger.error((Object)"Error occurred while trying to delete local file containing password.", (Throwable)e);
            throw new PasswordStorageException("Error occurred while trying to delete password with alias [ " + alias + " ].", (Throwable)e);
        }
    }

    private char[] readPasswordFile(String alias) throws PasswordStorageException, IOException {
        String password = this.getPasswordByAlias(alias);
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }

    private void validateAlias(String alias) {
        Pattern p = Pattern.compile("\\w*?\\d*?_*?");
        Matcher m = p.matcher(alias);
        boolean matches = m.matches();
        if (!matches) {
            throw new IllegalArgumentException("Password alias contains unallowed characters. Password alias should match the pattern \\w*?\\d*?_*?");
        }
    }

    private void addPasswordForAlias(String alias, char[] password) throws PasswordStorageException, IOException {
        this.loadPropertiesFromFile();
        this.aliasPasswordProperties.put(alias, new String(password));
        this.storePropertiesToFile();
    }

    private String getPasswordByAlias(String alias) throws IOException {
        this.loadPropertiesFromFile();
        return this.aliasPasswordProperties.getProperty(alias);
    }

    private void deletePasswordForAlias(String alias) throws PasswordStorageException, IOException {
        this.loadPropertiesFromFile();
        if (this.aliasPasswordProperties.containsKey(alias)) {
            this.aliasPasswordProperties.remove(alias);
        }
        this.storePropertiesToFile();
    }

    private void loadPropertiesFromFile() throws IOException {
        if (this.aliasPasswordProperties == null) {
            this.aliasPasswordProperties = new Properties();
            if (this.aliasPasswordFile.exists()) {
                FileInputStream is = new FileInputStream(this.aliasPasswordFile);
                try (InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                    this.aliasPasswordProperties.load(reader);
                }
            }
        }
    }

    private void storePropertiesToFile() throws PasswordStorageException {
        FileOutputStream propsFileOut = null;
        try {
            try {
                propsFileOut = new FileOutputStream(this.aliasPasswordFile);
                this.aliasPasswordProperties.store(propsFileOut, "");
            }
            catch (IOException e) {
                logger.error((Object)"Error occurred while trying to create local file to store the password.", (Throwable)e);
                throw new PasswordStorageException("Error occurred while trying to set password with alias [ aliasPasswordFile ].", (Throwable)e);
            }
        }
        finally {
            if (propsFileOut != null) {
                try {
                    propsFileOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error occurred while trying to close file.", (Throwable)e);
                }
            }
        }
    }
}

