/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openejb.AppContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpResponseImpl;
import org.apache.openejb.server.httpd.ServletResponseAdapter;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.DaemonThreadFactory;

public class OpenEJBAsyncContext
implements AsyncContext {
    private static final Set<OpenEJBAsyncContext> INITIALIZED = new CopyOnWriteArraySet<OpenEJBAsyncContext>();
    private static volatile ScheduledExecutorService es;
    private final List<AsyncListener> listeners = new ArrayList<AsyncListener>();
    private final ServletResponse response;
    private final HttpServletRequest request;
    private final Socket socket;
    private final AsyncEvent event;
    private WebContext context = null;
    private final String contextPath;
    private volatile boolean started = false;
    private volatile boolean committed = false;
    private long timeout = 30000L;
    private long lastTouch = System.currentTimeMillis();

    public static void destroy() {
        if (es == null) {
            return;
        }
        es.shutdownNow();
        for (OpenEJBAsyncContext ctx : new ArrayList<OpenEJBAsyncContext>(INITIALIZED)) {
            if (ctx.lastTouch + ctx.getTimeout() >= System.currentTimeMillis()) continue;
            for (AsyncListener listener : ctx.listeners) {
                try {
                    listener.onTimeout(ctx.event);
                }
                catch (IOException t) {
                    throw new OpenEJBRuntimeException((Exception)t);
                }
            }
            ctx.complete();
        }
        INITIALIZED.clear();
    }

    public static void init() {
        if (!"true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.http.async.eviction", "true"))) {
            return;
        }
        es = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(new Class[]{OpenEJBAsyncContext.class}));
        es.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (OpenEJBAsyncContext ctx : new ArrayList(INITIALIZED)) {
                    if (ctx.lastTouch + ctx.getTimeout() >= System.currentTimeMillis()) continue;
                    INITIALIZED.remove(ctx);
                    for (AsyncListener listener : ctx.listeners) {
                        try {
                            listener.onTimeout(ctx.event);
                        }
                        catch (IOException t) {
                            throw new OpenEJBRuntimeException((Exception)t);
                        }
                    }
                    ctx.complete();
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public OpenEJBAsyncContext(HttpServletRequest request, ServletResponse response, String contextPath) {
        if (es == null) {
            Class<OpenEJBAsyncContext> clazz = OpenEJBAsyncContext.class;
            // MONITORENTER : org.apache.openejb.server.httpd.OpenEJBAsyncContext.class
            if (es == null) {
                OpenEJBAsyncContext.init();
            }
            // MONITOREXIT : clazz
        }
        this.request = request;
        this.contextPath = contextPath;
        if (contextPath != null) {
            block2: for (AppContext app : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
                for (WebContext web : app.getWebContexts()) {
                    if (!web.getContextRoot().replace("/", "").equals(contextPath.replace("/", ""))) continue;
                    this.context = web;
                    continue block2;
                }
            }
        }
        this.response = response;
        this.socket = (Socket)Socket.class.cast(request.getAttribute("openejb_socket"));
        this.event = new AsyncEvent((AsyncContext)this, (ServletRequest)request, response);
        INITIALIZED.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        for (AsyncListener listener : this.listeners) {
            try {
                listener.onComplete(this.event);
            }
            catch (IOException t) {
                throw new OpenEJBRuntimeException((Exception)t);
            }
        }
        try {
            this.commit();
        }
        finally {
            INITIALIZED.remove(this);
        }
    }

    private void onError(Throwable ignored) {
        for (AsyncListener listener : this.listeners) {
            try {
                listener.onError(this.event);
            }
            catch (IOException t) {
                throw new OpenEJBRuntimeException((Exception)t);
            }
        }
        try {
            ((HttpServletResponse)HttpServletResponse.class.cast(this.response)).sendError(500);
            this.commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void commit() {
        if (this.committed) {
            return;
        }
        this.committed = true;
        if (HttpResponseImpl.class.isInstance(this.response) && this.socket != null) {
            try {
                ((HttpResponseImpl)HttpResponseImpl.class.cast(this.response)).writeMessage(this.socket.getOutputStream(), false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void dispatch() {
        String pathInfo;
        String path;
        ServletRequest servletRequest = this.getRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest sr = (HttpServletRequest)servletRequest;
            path = sr.getServletPath();
            pathInfo = sr.getPathInfo();
        } else {
            path = this.request.getServletPath();
            pathInfo = this.request.getPathInfo();
        }
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        this.dispatch(path);
    }

    public void dispatch(String path) {
        this.dispatch(this.request.getServletContext(), path);
    }

    public void dispatch(ServletContext context, final String path) {
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        try {
            final String contextPath = this.context == null ? this.contextPath : (this.context.getContextRoot().startsWith("/") ? this.context.getContextRoot() : '/' + this.context.getContextRoot());
            HttpRequestImpl req = new HttpRequestImpl(new URI(this.request.getRequestURI())){
                private String thisPath;
                private String thisContextPath;
                {
                    super(x0);
                    this.thisPath = path;
                    this.thisContextPath = contextPath;
                }

                @Override
                public String getContextPath() {
                    return this.thisContextPath;
                }

                @Override
                public String getServletPath() {
                    return this.thisPath;
                }

                @Override
                public void initServletPath(String servlet) {
                    this.thisPath = servlet;
                }

                @Override
                public void initPathFromContext(String context) {
                    super.initPathFromContext(context);
                    this.thisContextPath = super.getContextPath();
                }

                @Override
                public String getRequestURI() {
                    return contextPath + path;
                }

                @Override
                public ServletInputStream getInputStream() throws IOException {
                    return OpenEJBAsyncContext.this.request.getInputStream();
                }

                @Override
                public Object getAttribute(String name) {
                    return OpenEJBAsyncContext.this.request.getAttribute(name);
                }

                @Override
                public Enumeration<String> getAttributeNames() {
                    return OpenEJBAsyncContext.this.request.getAttributeNames();
                }

                @Override
                public void setAttribute(String name, Object value) {
                    OpenEJBAsyncContext.this.request.setAttribute(name, value);
                }

                @Override
                public String getHeader(String name) {
                    return OpenEJBAsyncContext.this.request.getHeader(name);
                }

                @Override
                public Enumeration<String> getHeaderNames() {
                    return OpenEJBAsyncContext.this.request.getHeaderNames();
                }

                @Override
                public Enumeration<String> getHeaders(String s) {
                    return OpenEJBAsyncContext.this.request.getHeaders(s);
                }

                @Override
                public int getIntHeader(String s) {
                    return OpenEJBAsyncContext.this.request.getIntHeader(s);
                }

                @Override
                public String getMethod() {
                    return OpenEJBAsyncContext.this.request.getMethod();
                }
            };
            if (HttpRequestImpl.class.isInstance(this.request)) {
                req.setUri(((HttpRequestImpl)HttpRequestImpl.class.cast(this.request)).getURI());
            }
            req.setAttribute("openejb_async_dispatch", true);
            registry.onMessage(req, HttpResponse.class.isInstance(this.response) ? (HttpResponse)HttpResponse.class.cast(this.response) : new ServletResponseAdapter((HttpServletResponse)HttpServletResponse.class.cast(this.response)));
            this.complete();
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        if (this.response == null) {
            throw new IllegalStateException("no response");
        }
        return this.response;
    }

    public void start(Runnable run) {
        this.internalStartAsync();
        run.run();
    }

    public void internalStartAsync() {
        this.started = true;
        for (AsyncListener listener : this.listeners) {
            try {
                listener.onStartAsync(this.event);
            }
            catch (IOException t) {
                throw new OpenEJBRuntimeException((Exception)t);
            }
        }
    }

    public void addListener(AsyncListener listener) {
        this.listeners.add(listener);
        if (this.started) {
            try {
                listener.onStartAsync(this.event);
            }
            catch (IOException e) {
                throw new OpenEJBRuntimeException((Exception)e);
            }
        }
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.addListener(listener);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)this.context.inject(clazz.newInstance()));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean hasOriginalRequestAndResponse() {
        return true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

