/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.local.crypto;

import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionCorruptedException;
import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionKeyCorruptedException;
import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionKeyNotFoundException;
import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionPropertiesCorruptedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public abstract class DestinationPasswordEncryptDecrypt {
    private static final Logger log = Logger.getLogger(DestinationPasswordEncryptDecrypt.class);
    public static final String KEY_ENCRYPTION_KEY_LOCATION = "encryption-key-location";
    private static final String CHARSET_NAME = "ISO-8859-1";
    private static final String KEY_DEST_TYPE = "Type";
    private static final String KEY_DEST_AUTH = "Authentication";
    private static final String KEY_JCO_CLIENT_PASSWD = "jco.client.passwd";
    private static final String KEY_JCO_DESTINATION_REPOSITORY_PASSWD = "jco.destination.repository.passwd";
    private static final String KEY_MAIL_PASSWORD = "mail.password";
    private static final String KEY_PASSWORD = "Password";
    private static final String KEY_STORE_PASSWORD = "KeyStorePassword";
    private static final String KEY_TRUST_STORE_PASSWORD = "TrustStorePassword";
    private static final String KEY_CLIENT_KEY = "clientKey";
    private static final String KEY_TOKEN_SERVICE_PASSWORD = "tokenServicePassword";
    private static final String KEY_CERTIFICATE = "Certificate";
    private static final String KEY_SIGNING_KEY = "SigningKey";
    private static final String DEST_TYPE_HTTP = "HTTP";
    private static final String DEST_TYPE_MAIL = "MAIL";
    private static final String DEST_TYPE_RFC = "RFC";
    private static final String DEST_AUTH_BASIC = "BasicAuthentication";
    private static final String DEST_AUTH_CLIENT_CERTIFICATE = "ClientCertificateAuthentication";
    private static final String DEST_AUTH_APP2APP_SSO = "AppToAppSSO";
    private static final String DEST_AUTH_SAML_BEARER_ASSERTION = "OAuth2SAMLBearerAssertion";
    private static final String DEST_AUTH_SAP_ASSERTION_SSO = "SAPAssertionSSO";
    private static final String AES_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";
    private static final String KEY_ENCRYPT_DECRYPT_KEY = "key";
    private static final String KEY_IV_PARAMS = "iv";
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static DestinationPasswordEncryptDecrypt JCO_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"jco.client.passwd", "jco.destination.repository.passwd"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_RFC.equals(type);
        }
    };
    private static DestinationPasswordEncryptDecrypt MAIL_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"mail.password"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_MAIL.equals(type);
        }
    };
    private static DestinationPasswordEncryptDecrypt BASIC_AUTH_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"Password"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            String auth = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_AUTH);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_HTTP.equals(type) && DestinationPasswordEncryptDecrypt.DEST_AUTH_BASIC.equals(auth);
        }
    };
    private static DestinationPasswordEncryptDecrypt CLIENT_CERTIFICATE_AUTH_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"KeyStorePassword", "TrustStorePassword"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            String auth = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_AUTH);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_HTTP.equals(type) && DestinationPasswordEncryptDecrypt.DEST_AUTH_CLIENT_CERTIFICATE.equals(auth);
        }
    };
    private static DestinationPasswordEncryptDecrypt APP2APP_SSO_AUTH_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"TrustStorePassword"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            String auth = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_AUTH);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_HTTP.equals(type) && DestinationPasswordEncryptDecrypt.DEST_AUTH_APP2APP_SSO.equals(auth);
        }
    };
    private static DestinationPasswordEncryptDecrypt SAML_BEARER_ASSERTION_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"clientKey", "tokenServicePassword", "TrustStorePassword"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            String auth = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_AUTH);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_HTTP.equals(type) && DestinationPasswordEncryptDecrypt.DEST_AUTH_SAML_BEARER_ASSERTION.equals(auth);
        }
    };
    private static DestinationPasswordEncryptDecrypt SAP_ASSERTION_SSO_ENCRYPT_DECRYPT = new DestinationPasswordEncryptDecrypt(new String[]{"SigningKey", "Certificate", "TrustStorePassword"}){

        @Override
        public boolean isConfigurationMatching(Properties configuration) {
            if (this.isEmpty(configuration)) {
                return false;
            }
            String type = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_TYPE);
            String auth = configuration.getProperty(DestinationPasswordEncryptDecrypt.KEY_DEST_AUTH);
            return DestinationPasswordEncryptDecrypt.DEST_TYPE_HTTP.equals(type) && DestinationPasswordEncryptDecrypt.DEST_AUTH_SAP_ASSERTION_SSO.equals(auth);
        }
    };
    private String[] passwordKeys;

    private String handleEncryptDecryptForValue(int mode, String name, String value, Cipher cipher) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        try {
            if (mode == 1) {
                String string = DatatypeConverter.printHexBinary((byte[])cipher.doFinal(value.getBytes(CHARSET)));
                return string;
            }
            String string = new String(cipher.doFinal(DatatypeConverter.parseHexBinary((String)value)), CHARSET);
            return string;
        }
        finally {
            try {
                cipher.doFinal();
            }
            catch (Exception ex) {
                log.error((Object)"Failed to reset the cipher", (Throwable)ex);
            }
        }
    }

    public static Collection<DestinationPasswordEncryptDecrypt> getDefaultPasswordEncrypters() {
        return Arrays.asList(JCO_ENCRYPT_DECRYPT, MAIL_ENCRYPT_DECRYPT, BASIC_AUTH_ENCRYPT_DECRYPT, CLIENT_CERTIFICATE_AUTH_ENCRYPT_DECRYPT, APP2APP_SSO_AUTH_ENCRYPT_DECRYPT, SAML_BEARER_ASSERTION_ENCRYPT_DECRYPT, SAP_ASSERTION_SSO_ENCRYPT_DECRYPT);
    }

    public DestinationPasswordEncryptDecrypt(String ... passwordKeys) {
        this.passwordKeys = passwordKeys;
    }

    public static DestinationPasswordEncryptDecrypt getDefaultPasswordEncrypter(Properties configuration) {
        for (DestinationPasswordEncryptDecrypt encrypter : DestinationPasswordEncryptDecrypt.getDefaultPasswordEncrypters()) {
            if (!encrypter.isConfigurationMatching(configuration)) continue;
            return encrypter;
        }
        return null;
    }

    public abstract boolean isConfigurationMatching(Properties var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getEncryptDecryptKey(Properties configuration) throws EncryptionKeyNotFoundException, EncryptionKeyCorruptedException {
        Properties properties;
        String keyPath = configuration.getProperty(KEY_ENCRYPTION_KEY_LOCATION);
        File keyFile = new File(keyPath);
        FileInputStream fileInputStream = null;
        try {
            Properties properties2 = new Properties();
            fileInputStream = new FileInputStream(keyFile);
            try {
                properties2.load(fileInputStream);
            }
            catch (IOException iOException) {
                throw new EncryptionKeyCorruptedException("An error occurred while reading key file at " + keyPath);
            }
            properties = properties2;
            if (fileInputStream == null) return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new EncryptionKeyNotFoundException("The specified key file at " + keyPath + " does not exist");
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }

    private void handleEncryptDecryptOperation(int mode, Properties configuration, boolean restoreOnFail) throws EncryptionKeyNotFoundException, NoSuchAlgorithmException, NoSuchPaddingException, EncryptionCorruptedException {
        List<String> corruptedProps;
        Properties keyProps = this.getEncryptDecryptKey(configuration);
        String encryptionKey = keyProps.getProperty(KEY_ENCRYPT_DECRYPT_KEY);
        String iv = keyProps.getProperty(KEY_IV_PARAMS);
        if (encryptionKey == null || iv == null) {
            throw new EncryptionKeyCorruptedException("The specified key file is not in the correct format");
        }
        SecretKeySpec key = null;
        try {
            key = new SecretKeySpec(DatatypeConverter.parseHexBinary((String)encryptionKey), "AES");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EncryptionKeyCorruptedException("The provided Key is invalid");
        }
        IvParameterSpec ivParams = null;
        try {
            ivParams = new IvParameterSpec(DatatypeConverter.parseHexBinary((String)iv));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EncryptionKeyCorruptedException("The provided IV is invalid");
        }
        Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5PADDING);
        try {
            cipher.init(mode, (Key)key, ivParams);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionKeyCorruptedException("The provided Key is invalid");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new EncryptionKeyCorruptedException("The provided IV is invalid");
        }
        Properties savedConfigurations = null;
        if (restoreOnFail) {
            savedConfigurations = new Properties();
            savedConfigurations.putAll((Map<?, ?>)configuration);
        }
        if ((corruptedProps = this.changeProperties(configuration, mode, cipher)) != null) {
            if (restoreOnFail) {
                configuration.clear();
                configuration.putAll((Map<?, ?>)savedConfigurations);
            }
            throw new EncryptionPropertiesCorruptedException("One or more properties could not be decrypted", corruptedProps);
        }
    }

    private List<String> changeProperties(Properties configuration, int mode, Cipher cipher) throws NoSuchAlgorithmException, NoSuchPaddingException {
        ArrayList<String> corruptedProperties = null;
        String[] stringArray = this.passwordKeys;
        int n = this.passwordKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String privateProperty = stringArray[n2];
            String value = configuration.getProperty(privateProperty);
            if (value != null) {
                try {
                    configuration.setProperty(privateProperty, this.handleEncryptDecryptForValue(mode, privateProperty, value, cipher));
                }
                catch (NoSuchAlgorithmException ex) {
                    throw ex;
                }
                catch (NoSuchPaddingException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    if (corruptedProperties == null) {
                        corruptedProperties = new ArrayList<String>();
                    }
                    corruptedProperties.add(privateProperty);
                }
            }
            ++n2;
        }
        return corruptedProperties;
    }

    public void encryptPasswordProperties(Properties configuration, boolean discardPartialEncryption) throws NoSuchAlgorithmException, NoSuchPaddingException, EncryptionKeyNotFoundException, EncryptionCorruptedException {
        this.handleEncryptDecryptOperation(1, configuration, discardPartialEncryption);
    }

    public void encryptPasswordProperties(Properties configuration) throws NoSuchAlgorithmException, NoSuchPaddingException, EncryptionKeyNotFoundException, EncryptionCorruptedException {
        this.encryptPasswordProperties(configuration, false);
    }

    public void decryptPasswordProperties(Properties configuration, boolean discardPartialDecryption) throws NoSuchAlgorithmException, NoSuchPaddingException, EncryptionKeyNotFoundException, EncryptionCorruptedException {
        this.handleEncryptDecryptOperation(2, configuration, discardPartialDecryption);
    }

    public void decryptPasswordProperties(Properties configuration) throws NoSuchAlgorithmException, NoSuchPaddingException, EncryptionKeyNotFoundException, EncryptionCorruptedException {
        this.decryptPasswordProperties(configuration, false);
    }

    protected boolean isEmpty(Properties configuration) {
        return configuration == null || configuration.isEmpty();
    }

    public String[] getPasswordKeys() {
        return this.passwordKeys;
    }
}

