/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.client.ConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.handshake.ClientHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractClient<T extends ConnectionAttributes> {
    private static final Logger logger = Logger.getLogger(AbstractClient.class);
    protected final TunnelConfiguration configuration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
    protected final TunnelEndpoint endpoint;
    protected final String clientId;
    private EventLoopGroup workerGroup;
    private final ChannelGroup channelGroup = new DefaultChannelGroup("tunnel_channels", (EventExecutor)GlobalEventExecutor.INSTANCE);

    public AbstractClient(TunnelEndpoint endpoint, String clientId) {
        this.endpoint = endpoint;
        this.clientId = clientId;
    }

    protected final synchronized TunnelClientHandshakeFuture doConnect(T attributes) {
        if (this.workerGroup == null) {
            this.workerGroup = new NioEventLoopGroup(this.configuration.getClientPoolSize(), (ThreadFactory)new DefaultThreadFactory(this.getName()));
        }
        ChannelInitializer<?> channelInitializer = this.createChannelInitializer(attributes);
        ChannelFuture openConnectionFuture = this.establishConnection(this.getProxy(), this.getTunnelServerAddress(attributes), channelInitializer);
        TunnelClientHandshakeFuture handshakeFuture = new TunnelClientHandshakeFuture(openConnectionFuture.channel());
        openConnectionFuture.addListener((GenericFutureListener)new OpenConnectionListener(attributes.getTunnelId(), handshakeFuture));
        return handshakeFuture;
    }

    protected abstract String getName();

    private ChannelFuture establishConnection(HTTPSProxy proxy, InetSocketAddress serverAddress, ChannelInitializer<?> channelInitializer) {
        ChannelFuture connectFuture;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).handler(channelInitializer);
        this.initBootstrap(bootstrap);
        if (proxy != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Connecting to address %s using proxy %s. Proxy user is %s", serverAddress, proxy.getAddress(), proxy.getUser() != null ? proxy.getUser() : "not set."));
            }
            connectFuture = bootstrap.connect((SocketAddress)proxy.getAddress());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Connecting to address %s. No proxy is used.", serverAddress));
            }
            connectFuture = bootstrap.connect((SocketAddress)serverAddress);
        }
        return connectFuture;
    }

    protected void initBootstrap(Bootstrap bootstrap) {
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    protected InetSocketAddress getTunnelServerAddress(T attributes) {
        return attributes.getTunnelServerAddress() != null ? attributes.getTunnelServerAddress() : this.getServerAddress();
    }

    protected abstract ChannelInitializer<?> createChannelInitializer(T var1);

    protected abstract InetSocketAddress getServerAddress();

    protected abstract HTTPSProxy getProxy();

    protected final synchronized void doDisconnect() {
        this.channelGroup.close().awaitUninterruptibly();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
            this.workerGroup = null;
        }
    }

    private class HandshakeListener
    implements ChannelFutureListener {
        private HandshakeListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Tunnel handshake failed! Closing the tunnel channel immediately", future.cause());
                }
                ChannelUtil.closeImmediately((Channel)future.channel());
            }
        }
    }

    private class OpenConnectionListener
    implements ChannelFutureListener {
        private final TunnelClientHandshakeFuture handshakeFuture;
        private final String tunnelId;

        public OpenConnectionListener(String tunnelId, TunnelClientHandshakeFuture future) {
            this.tunnelId = tunnelId;
            this.handshakeFuture = future;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            Channel channel = future.channel();
            if (future.isSuccess()) {
                AbstractClient.this.channelGroup.add((Object)channel);
                this.handshakeFuture.addListener((GenericFutureListener)new HandshakeListener());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Successfully connected channel: %s. Starting handshake with tunnel server for tunnel ID: %s", channel, this.tunnelId));
                }
                ClientHandshaker clientHandshaker = (ClientHandshaker)channel.pipeline().get(ClientHandshaker.class);
                clientHandshaker.handshake(this.handshakeFuture);
            } else {
                this.handshakeFuture.setFailure(future.cause());
            }
        }
    }
}

