/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.client.AbstractClient;
import com.sap.core.connectivity.tunnel.client.TunnelClientChannelInitializer;
import com.sap.core.connectivity.tunnel.client.TunnelClientConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.TunnelNotAllowedException;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeResult;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshaker;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public abstract class AbstractTunnelClient<T extends TunnelClientConnectionAttributes>
extends AbstractClient<T> {
    private static final Logger log = Logger.getLogger(AbstractTunnelClient.class);
    protected final ConnectivityContext connectivityContext;

    protected AbstractTunnelClient(TunnelEndpoint endpoint, String clientId, ConnectivityContext connectivityContext) {
        super(endpoint, clientId);
        this.connectivityContext = connectivityContext;
    }

    @Override
    protected final String getName() {
        return "tunnel-client";
    }

    public void connect(T attributes) throws TunnelNotAllowedException, TunnelRegistrationException {
        for (int i = 0; i < attributes.getConnectionCount(); ++i) {
            TunnelClientHandshakeFuture handshakeFuture = this.doConnect(attributes);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Waiting the handshake with tunnel server to complete for tunnel ID: %s", attributes.getTunnelId()));
            }
            handshakeFuture.syncUninterruptibly();
            Channel channel = handshakeFuture.channel();
            this.tunnelOpened(channel, attributes, handshakeFuture.getHandshakeResult());
            log.info((Object)("Successfully established tunnel: " + channel));
            channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener((TunnelClientConnectionAttributes)attributes){
                final /* synthetic */ TunnelClientConnectionAttributes val$attributes;
                {
                    this.val$attributes = tunnelClientConnectionAttributes;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    AbstractTunnelClient.this.tunnelClosed(future.channel(), this.val$attributes);
                }
            });
            channel.config().setAutoRead(true);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format("Enabled reading from channel %s for tunnel ID: %s", channel, attributes.getTunnelId()));
        }
    }

    @Override
    protected final void initBootstrap(Bootstrap bootstrap) {
        super.initBootstrap(bootstrap);
        int channelWriteBufferSize = this.configuration.getClientChannelWriteBufferSize();
        if (channelWriteBufferSize >= 0) {
            bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(channelWriteBufferSize / 2, channelWriteBufferSize));
        }
    }

    public void disconnect() {
        this.doDisconnect();
    }

    protected void tunnelOpened(Channel channel, T attributes, TunnelClientHandshakeResult handshakeResult) {
    }

    protected void tunnelClosed(Channel channel, T attributes) {
    }

    @Override
    protected final ChannelInitializer<?> createChannelInitializer(T attributes) {
        TunnelClientHandshaker tunnelClientHandshaker = new TunnelClientHandshaker(this.connectivityContext, attributes.getTunnelId(), this.clientId, this.endpoint, this.getTunnelServerAddress(attributes), attributes.getRoutingInformation(), this.getProxy());
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.connectivityContext.getServiceRegistry().getService(TunnelConfiguration.class);
        TunnelClientChannelInitializer pipelineFactory = new TunnelClientChannelInitializer(this.connectivityContext, attributes.getTunnelId(), tunnelClientHandshaker, tunnelConfiguration.getIdleTime());
        return pipelineFactory;
    }

    @Override
    protected final InetSocketAddress getServerAddress() {
        return this.endpoint.getTunnelServerAddress();
    }

    @Override
    protected HTTPSProxy getProxy() {
        return this.endpoint.getTunnelServerHttpsProxy();
    }
}

