/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelStateListener;
import com.sap.core.connectivity.tunnel.client.AbstractTunnelClient;
import com.sap.core.connectivity.tunnel.client.DirectTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import io.netty.channel.Channel;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DirectTunnelClient
extends AbstractTunnelClient<DirectTunnelConnectionAttributes> {
    private static final Logger log = Logger.getLogger(DirectTunnelClient.class);
    private final Set<TunnelStateListener> listeners = new LinkedHashSet<TunnelStateListener>();

    public DirectTunnelClient(TunnelEndpoint endpoint, String clientId, ConnectivityContext connectivityContext) {
        super(endpoint, clientId, connectivityContext);
    }

    @Override
    protected void tunnelClosed(Channel channel, DirectTunnelConnectionAttributes attributes) {
        this.fireTunnelCloseEvent(attributes.getTunnelId());
    }

    public void addListener(TunnelStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TunnelStateListener listener) {
        this.listeners.remove(listener);
    }

    private void fireTunnelCloseEvent(final String tunnelId) {
        new Thread(String.format("%s-tunnel-close-event-thread", Thread.currentThread().getName())){

            @Override
            public void run() {
                for (TunnelStateListener listener : DirectTunnelClient.this.listeners) {
                    try {
                        listener.tunnelClosed(tunnelId);
                    }
                    catch (RuntimeException e) {
                        log.error((Object)"Firing tunnel close event threw an exception", (Throwable)e);
                    }
                }
            }
        }.start();
    }
}

