/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.cloud.auditlog.AuditLogMessageFactory;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableService;
import com.sap.core.connectivity.tunnel.api.audit.AuditProvider;
import com.sap.core.connectivity.tunnel.api.audit.TunnelSecurityEventAuditMessage;
import com.sap.core.connectivity.tunnel.api.management.TunnelConnectionInformation;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelInformation;
import com.sap.core.connectivity.tunnel.api.trust.TunnelAttributes;
import com.sap.core.connectivity.tunnel.api.trust.TunnelControl;
import com.sap.core.connectivity.tunnel.client.AbstractTunnelClient;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelClientInformationStore;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelDisconnector;
import com.sap.core.connectivity.tunnel.client.TunnelNotAllowedException;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeResult;
import com.sap.core.connectivity.tunnel.client.sso.SSOClientProcessor;
import com.sap.core.connectivity.tunnel.client.sso.SSOClientSessionService;
import com.sap.core.connectivity.tunnel.client.sso.SSOSessionService;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ManagedTunnelClient
extends AbstractTunnelClient<ManagedTunnelConnectionAttributes> {
    private static Logger log = Logger.getLogger(ManagedTunnelClient.class);
    private AuditProvider auditProvider;
    private final SSOClientSessionService ssoClientSessionService;
    private final ManagedTunnelClientInformationStore infoStore = new ManagedTunnelClientInformationStore();
    private final ManagedTunnelDisconnector managedTunnelControl;
    private final ServiceRegistry serviceRegistry;

    public ManagedTunnelClient(TunnelEndpoint endpoint, String clientId, ConnectivityContext connectivityContext) {
        super(endpoint, clientId, connectivityContext);
        this.serviceRegistry = connectivityContext.getServiceRegistry();
        this.ssoClientSessionService = new SSOClientSessionService(this.serviceRegistry, this.infoStore);
        this.serviceRegistry.registerService(SSOSessionService.class, (TunnelConsumableService)this.ssoClientSessionService);
        this.connectivityContext.registerMessagePacketProcessor(15, (MessagePacketProcessor)new SSOClientProcessor(connectivityContext));
        this.managedTunnelControl = new ManagedTunnelDisconnector(this.infoStore, this.serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(ManagedTunnelConnectionAttributes attributes) throws TunnelNotAllowedException, TunnelRegistrationException {
        if (!this.getTunnelControl().isTunnelAllowed(attributes.getTunnelId(), attributes.getTunnelAttributes())) {
            this.auditLogAppTunnelDenied(attributes);
            throw new TunnelNotAllowedException(MessageFormat.format("Denied access for tunnel with id ''{0}'' and attributes: ''{1}''", attributes.getTunnelId(), attributes.getTunnelAttributes()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Allowed access for tunnel with id ''{0}'' and attributes: ''{1}''", attributes.getTunnelId(), attributes.getTunnelAttributes()));
        }
        Object object = this.ssoClientSessionService;
        synchronized (object) {
            if (!this.ssoClientSessionService.isStarted()) {
                this.ssoClientSessionService.start(this.configuration.getSSOSessionInvalidationPeriodInSeconds(), TimeUnit.SECONDS);
            }
        }
        object = this.managedTunnelControl;
        synchronized (object) {
            if (!this.managedTunnelControl.isStarted()) {
                this.managedTunnelControl.start();
            }
        }
        super.connect(attributes);
    }

    public TunnelInformation getTunnelInformation(String tunnelId) {
        return this.infoStore.getTunnelInformation(tunnelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        try {
            super.disconnect();
            Object object = this.ssoClientSessionService;
            synchronized (object) {
                if (this.ssoClientSessionService.isStarted()) {
                    this.ssoClientSessionService.shutdown();
                }
            }
            object = this.managedTunnelControl;
            synchronized (object) {
                if (this.managedTunnelControl.isStarted()) {
                    this.managedTunnelControl.stop();
                }
            }
        }
        finally {
            this.infoStore.clear();
        }
    }

    @Override
    protected void tunnelOpened(Channel channel, ManagedTunnelConnectionAttributes attributes, TunnelClientHandshakeResult handshakeResult) {
        this.infoStore.tunnelConnectionOpened(channel, attributes, handshakeResult);
        this.auditLogAppTunnelOpened(attributes, channel, handshakeResult.getVmIdentifier());
    }

    @Override
    protected void tunnelClosed(Channel channel, ManagedTunnelConnectionAttributes attributes) {
        TunnelConnectionInformation connectionInformation = this.infoStore.tunnelConnectionClosed(channel, attributes);
        this.auditLogAppTunnelClosed(attributes, channel, connectionInformation.getPeerLabel());
    }

    public void disconnect(String tunnelId) {
        this.connectivityContext.getTunnelRegistry().closeTunnel(tunnelId);
    }

    private void auditLogAppTunnelOpened(ManagedTunnelConnectionAttributes attributes, Channel channel, String peerLabel) {
        this.auditLog(attributes, channel, peerLabel, "SERVICE_STARTED");
    }

    private void auditLogAppTunnelClosed(ManagedTunnelConnectionAttributes attributes, Channel channel, String peerLabel) {
        this.auditLog(attributes, channel, peerLabel, "SERVICE_STOPPED");
    }

    private void auditLogAppTunnelDenied(ManagedTunnelConnectionAttributes attributes) {
        this.auditLog(attributes, null, null, "ACCESS_DENIED");
    }

    private void auditLog(ManagedTunnelConnectionAttributes attributes, Channel channel, String peerLabel, String action) {
        if (this.auditProvider == null) {
            this.auditProvider = (AuditProvider)this.connectivityContext.getServiceRegistry().getService(AuditProvider.class);
        }
        AuditLogMessageFactory auditLogMessageFactory = this.auditProvider.getAuditLogMessageFactory(attributes.getTunnelId());
        TunnelAttributes tunnelAttributes = attributes.getTunnelAttributes();
        try {
            TunnelSecurityEventAuditMessage message = (TunnelSecurityEventAuditMessage)auditLogMessageFactory.createAuditLogMessage(TunnelSecurityEventAuditMessage.class);
            message.setAction(action);
            message.addObjectAttribute("applicationName", tunnelAttributes.getAttribute("applicationName"));
            message.addObjectAttribute("applicationAccount", tunnelAttributes.getAttribute("applicationAccount"));
            if (channel != null) {
                message.addObjectAttribute("applicationTunnelId", ChannelUtil.formatConnectionId((int)ConnectionId.get((Channel)channel)));
            }
            if (peerLabel != null) {
                message.addObjectAttribute("peerLabel", peerLabel);
            }
            message.setObjectId("applicationTunnel");
            message.setObjectName(attributes.getTunnelId());
            message.addCustomAttribute("tunnelId", attributes.getTunnelId());
            message.log(this.getClass());
        }
        catch (AuditLogWriteException alwe) {
            throw new RuntimeException("There is a problem with audit logging", alwe);
        }
    }

    private TunnelControl getTunnelControl() {
        return (TunnelControl)this.serviceRegistry.getService(TunnelControl.class);
    }
}

