/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.tunnel.api.management.TunnelConnectionInformation;
import com.sap.core.connectivity.tunnel.api.management.TunnelInformation;
import com.sap.core.connectivity.tunnel.api.trust.TunnelAttributes;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.TunnelInformationStore;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeResult;
import com.sap.core.connectivity.tunnel.client.management.TunnelConnectionInformationImpl;
import com.sap.core.connectivity.tunnel.client.management.TunnelInformationImpl;
import io.netty.channel.Channel;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ManagedTunnelClientInformationStore
implements TunnelInformationStore {
    private final ConcurrentHashMap<String, TunnelInformationImpl> tunnelInformationMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, ManagedTunnelConnectionAttributes> connectionAttributesMap = new ConcurrentHashMap();

    ManagedTunnelClientInformationStore() {
    }

    TunnelInformation getTunnelInformation(String tunnelId) {
        return this.tunnelInformationMap.get(tunnelId);
    }

    synchronized void tunnelConnectionOpened(Channel channel, ManagedTunnelConnectionAttributes attributes, TunnelClientHandshakeResult handshakeResult) {
        this.addConnectionAttributes(attributes, channel);
        this.addConnectionInformation(attributes, channel, handshakeResult);
    }

    private void addConnectionAttributes(ManagedTunnelConnectionAttributes attributes, Channel channel) {
        this.connectionAttributesMap.put(channel, attributes);
    }

    private void addConnectionInformation(ManagedTunnelConnectionAttributes attributes, Channel channel, TunnelClientHandshakeResult result) {
        String applicationName = attributes.getTunnelAttributes().getAttribute("applicationName");
        String applicationType = attributes.getTunnelAttributes().getAttribute("applicationType");
        String accountName = attributes.getTunnelAttributes().getAttribute("applicationAccount");
        this.tunnelInformationMap.putIfAbsent(attributes.getTunnelId(), new TunnelInformationImpl());
        TunnelInformationImpl tunnelInformation = this.tunnelInformationMap.get(attributes.getTunnelId());
        tunnelInformation.addConnectionInformation(channel, new TunnelConnectionInformationImpl(applicationName, applicationType, result.getVmIdentifier(), accountName));
    }

    synchronized TunnelConnectionInformation tunnelConnectionClosed(Channel channel, ManagedTunnelConnectionAttributes attributes) {
        this.removeConnectionAttributes(channel);
        return this.removeConnectionInformation(attributes, channel);
    }

    private void removeConnectionAttributes(Channel channel) {
        this.connectionAttributesMap.remove(channel);
    }

    private TunnelConnectionInformation removeConnectionInformation(ManagedTunnelConnectionAttributes attributes, Channel channel) {
        TunnelInformationImpl tunnelInformation = this.tunnelInformationMap.get(attributes.getTunnelId());
        TunnelConnectionInformation connectionInformation = tunnelInformation.removeConnectionInformation(channel);
        if (tunnelInformation.getConnections().isEmpty()) {
            this.tunnelInformationMap.remove(attributes.getTunnelId());
        }
        return connectionInformation;
    }

    Map<Channel, ManagedTunnelConnectionAttributes> getConnectionAttributes(String tunnelId) {
        HashMap<Channel, ManagedTunnelConnectionAttributes> result = new HashMap<Channel, ManagedTunnelConnectionAttributes>();
        for (Map.Entry<Channel, ManagedTunnelConnectionAttributes> connectionAttributesEntry : this.connectionAttributesMap.entrySet()) {
            ManagedTunnelConnectionAttributes connectionAttributes = connectionAttributesEntry.getValue();
            if (!tunnelId.equals(connectionAttributes.getTunnelId())) continue;
            result.put(connectionAttributesEntry.getKey(), connectionAttributes);
        }
        return Collections.unmodifiableMap(result);
    }

    void clear() {
        this.tunnelInformationMap.clear();
        this.connectionAttributesMap.clear();
    }

    @Override
    public TunnelAttributes getTunnelAttributes(Channel channel) {
        ManagedTunnelConnectionAttributes managedTunnelConnectionAttributes = this.connectionAttributesMap.get(channel);
        if (managedTunnelConnectionAttributes == null) {
            throw new IllegalArgumentException(MessageFormat.format("Channel {0} is not a tunnel channel or no attributes have been associated with it", channel));
        }
        return managedTunnelConnectionAttributes.getTunnelAttributes();
    }
}

