/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.trust.TunnelControl;
import com.sap.core.connectivity.tunnel.api.trust.TunnelControlListener;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelClientInformationStore;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelConnectionAttributes;
import io.netty.channel.Channel;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

class ManagedTunnelDisconnector
implements TunnelControlListener {
    private static Logger log = Logger.getLogger(ManagedTunnelDisconnector.class);
    private final ManagedTunnelClientInformationStore infoStore;
    private final ServiceRegistry serviceRegistry;
    private final AtomicBoolean started = new AtomicBoolean(false);

    ManagedTunnelDisconnector(ManagedTunnelClientInformationStore infoStore, ServiceRegistry serviceRegistry) {
        this.infoStore = infoStore;
        this.serviceRegistry = serviceRegistry;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        this.getTunnelControl().addListener((TunnelControlListener)this);
        this.started.set(true);
    }

    public void stop() {
        this.getTunnelControl().removeListener((TunnelControlListener)this);
        this.started.set(false);
    }

    public void accessRestrictionsChanged(String tunnelId) {
        for (Map.Entry<Channel, ManagedTunnelConnectionAttributes> connectionAttributesEntry : this.infoStore.getConnectionAttributes(tunnelId).entrySet()) {
            if (this.getTunnelControl().isTunnelAllowed(tunnelId, connectionAttributesEntry.getValue().getTunnelAttributes())) continue;
            Channel channel = connectionAttributesEntry.getKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("Access restrictions changed, closing tunnel channel {0}", channel));
            }
            ChannelUtil.close((Channel)channel);
        }
    }

    private TunnelControl getTunnelControl() {
        return (TunnelControl)this.serviceRegistry.getService(TunnelControl.class);
    }
}

