/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.client.handshake.AbstractClientHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeException;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class NotificationClientHandshaker
extends AbstractClientHandshaker {
    private static final Logger log = Logger.getLogger(NotificationClientHandshaker.class);
    private State state;

    public NotificationClientHandshaker(ConnectivityContext connectivityContext, String tunnelId, TunnelEndpoint endpoint, String clientId, InetSocketAddress serverAddress, HTTPSProxy proxy) {
        super(connectivityContext, tunnelId, endpoint, clientId, serverAddress, null, proxy);
        this.state = proxy != null ? State.PROXY : (!this.isNotificationAgentProtocolDefined() ? State.PROTOCOL_NEGOTIATION : State.TUNNEL);
    }

    @Override
    protected void handleChannelRead(ChannelHandlerContext ctx, HttpResponse response) throws Exception {
        switch (this.state) {
            case PROXY: {
                this.handleProxyHandshakeResponse(ctx, response);
                if (this.isNotificationAgentProtocolDefined()) {
                    this.state = State.TUNNEL;
                    this.prepareSSLCommunication(ctx.pipeline());
                    this.protocolHandshaker.handshake(ctx.channel(), this.getNotificationAgentTunnelProtocol());
                    break;
                }
                this.state = State.PROTOCOL_NEGOTIATION;
                this.prepareSSLCommunication(ctx.pipeline());
                this.sendCommunicationProtocolRequest(ctx.channel());
                break;
            }
            case PROTOCOL_NEGOTIATION: {
                if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                    log.error((Object)("Invalid communication protocol response: " + response));
                    throw new TunnelHandshakeException("Invalid communication protocol response: " + response.getStatus());
                }
                String protocol = response.headers().get("TUNNEL_PROTOCOL");
                if (protocol == null || !protocol.equals("connectivity") && !protocol.equals("websocket")) {
                    log.error((Object)("Invalid communication protocol header in handshake response: " + response));
                    throw new TunnelHandshakeException("Invalid communication protocol header in handshake response:  " + protocol);
                }
                this.handshakeProtocolStorage.registerProtocol(this.tunnelServerHost, protocol);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Received communication protocol response:\n" + response));
                }
                this.state = State.TUNNEL;
                this.protocolHandshaker.handshake(ctx.channel(), this.getNotificationAgentTunnelProtocol());
                break;
            }
            case TUNNEL: {
                this.handleTunnelHandshakeResponse(ctx, response);
            }
        }
    }

    @Override
    public void handshake(TunnelClientHandshakeFuture handshakeFuture) {
        this.future = handshakeFuture;
        switch (this.state) {
            case PROXY: {
                this.proxyHandshaker.handshake(this.future.channel());
                break;
            }
            case PROTOCOL_NEGOTIATION: {
                this.prepareSSLCommunication(this.future.channel().pipeline());
                this.sendCommunicationProtocolRequest(this.future.channel());
                break;
            }
            case TUNNEL: {
                this.prepareSSLCommunication(this.future.channel().pipeline());
                this.protocolHandshaker.handshake(this.future.channel(), this.getNotificationAgentTunnelProtocol());
            }
        }
    }

    private void sendCommunicationProtocolRequest(Channel channel) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/connectivity");
        request.headers().add("TUNNEL_PROTOCOL", (Object)"undefined");
        request.headers().set("Host", (Object)this.handshakeServerHost);
        channel.writeAndFlush((Object)request).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
    }

    private boolean isNotificationAgentProtocolDefined() {
        return this.handshakeProtocolStorage.isNotificationAgentProtocolStored(this.tunnelServerHost);
    }

    private static enum State {
        PROXY,
        TUNNEL,
        PROTOCOL_NEGOTIATION;

    }
}

